DELIMITER $$

DROP PROCEDURE IF EXISTS V20200618145610__InsertUITrsHostelForPortalNew $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200618145610__InsertUITrsHostelForPortalNew()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='IS_HOSTEL_REQUIRED')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','IS_HOSTEL_REQUIRED','Is Hostel Required ?','Is Hostel Required ?',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DIETARY_REQUIREMENT')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','DIETARY_REQUIREMENT','Does the student have any special dietary requirements','Does the student have any special dietary requirements',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='FOOD_ALLERGIES')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','FOOD_ALLERGIES','Does the student have any food allergies?','Does the student have any food allergies?',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SLEEPING_DISORDER')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','SLEEPING_DISORDER','Does the student have sleeping disorders?','Does the student have sleeping disorders?',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ANY_MEDICAL_OR_SOMETHING')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','ANY_MEDICAL_OR_SOMETHING','Are there any medical, emotional or physical needs that the boarding house should be aware of?','Are there any medical, emotional or physical needs that the boarding house should be aware of?',now(),1);
 END IF;
   
END $$

-- Execute the stored procedure
CALL V20200618145610__InsertUITrsHostelForPortalNew $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200618145610__InsertUITrsHostelForPortalNew $$
 
DELIMITER ;