DELIMITER $$

DROP PROCEDURE IF EXISTS V20200710161920__InsertApplicationDuplicateLinkTrans $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200710161920__InsertApplicationDuplicateLinkTrans()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='CHECK_DUPLICATE_EMAIL')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','CHECK_DUPLICATE_EMAIL','Check Duplicate Email','Check Duplicate Email','Merk duplikaat e-pos','Kiểm tra email trùng lặp',now(),1);
 END IF;

  
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='CHECK_DUPLICATE_NATIONAL_ID')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','CHECK_DUPLICATE_NATIONAL_ID','Check Duplicate National ID','Check Duplicate National ID','Gaan Duplikaat-nasionale ID na','Kiểm tra ID quốc gia trùng lặp',now(),1);

  END IF; 
  
END $$

-- Execute the stored procedure
CALL V20200710161920__InsertApplicationDuplicateLinkTrans() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200710161920__InsertApplicationDuplicateLinkTrans $$
 
DELIMITER ;