DELIMITER $$

DROP PROCEDURE IF EXISTS V20200716140812__InsertUITrnsSocioModuleName $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200716140812__InsertUITrnsSocioModuleName()

BEGIN
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='STEP33_SOCIO_ECONOMIC_INFORMATION')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','STEP33_SOCIO_ECONOMIC_INFORMATION','Socio Economic Information','Socio Economic Information','Sosio-ekonomiese inligting', 'Thông tin kinh tế xã hội',now(),1);
 END IF;
 
END $$

-- Execute the stored procedure
CALL V20200716140812__InsertUITrnsSocioModuleName $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200716140812__InsertUITrnsSocioModuleName $$
 
DELIMITER ;