DELIMITER $$
DROP PROCEDURE IF EXISTS V20200728162748__Insert_OfferStatusTranslation $$
CREATE PROCEDURE V20200728162748__Insert_OfferStatusTranslation()

BEGIN

	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='OFFER_STATUS')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('TRANSLATIONS','OFFER_STATUS','Offer Status','Offer Status','Tình trạng ưu đãi','Aanbodstatus',now(),1);
	END IF;  
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='PROVISIONAL_OFFER_ISSUED')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ADMISSION','PROVISIONAL_OFFER_ISSUED','Provisional Offer Issued','Provisional Offer Issued','Ưu đãi tạm thời đã ban hành','Voorlopige aanbod uitgereik',now(),1);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='PROVISIONAL_OFFER_REJECTED')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ADMISSION','PROVISIONAL_OFFER_REJECTED','Provisional Offer Rejected','Provisional Offer Rejected','Ưu đãi tạm thời bị từ chối','Voorlopige aanbod van die hand gewys',now(),1);
	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='PROVISIONAL_OFFER_DUE')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ADMISSION','PROVISIONAL_OFFER_DUE','Provisional Offer Due','Provisional Offer Due','Ưu đãi tạm thời','Voorlopige aanbod verskuldig',now(),1);
	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ERRORMESSAGE' and keyName='CANT_SEND_PROVISIONAL_OFFER_LETTER_DOCUMENT_NOT_MAPPED')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ERRORMESSAGE','CANT_SEND_PROVISIONAL_OFFER_LETTER_DOCUMENT_NOT_MAPPED','Provisional Offer Letter Document is not mapped','Provisional Offer Letter Document is not mapped','Tài liệu thư đề nghị tạm thời không được ánh xạ','Die voorlopige aanbiedingsbriefdokument is nie gekarteer nie',now(),1);
	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ERRORMESSAGE' and keyName='PROVISIONAL_OFFER_PROCESS_NOT_OPENED')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ERRORMESSAGE','PROVISIONAL_OFFER_PROCESS_NOT_OPENED','Provisional Offer Process is not started','Provisional Offer Process is not started','Quy trình ưu đãi tạm thời không được bắt đầu','Die voorlopige aanbiedingsproses is nie begin nie',now(),1);
	END IF; 
	
END $$

CALL V20200728162748__Insert_OfferStatusTranslation() $$
DROP PROCEDURE IF EXISTS V20200728162748__Insert_OfferStatusTranslation $$
DELIMITER ;
