DELIMITER $$

DROP PROCEDURE IF EXISTS V20200729121121__data_config_app_skip_table $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200729121121__data_config_app_skip_table()

BEGIN
  
 CREATE TABLE IF NOT EXISTS `search_skip_table` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `skipColumnName` VARCHAR(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `search_skip_table_id_UNIQUE` (`id` ASC),
  UNIQUE INDEX `search_skip_taskipColumnNameid_UNIQUE` (`skipColumnName` ASC))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8
COLLATE = utf8_bin;

INSERT INTO `search_skip_table` (`skipColumnName`) VALUES ('basic_search_config'),('basic_search_config_param'),('default_search_criterias'),('saved_search'),('saved_search_criteria'),('saved_search_sort_criteria'),('search_aggregation_column'),('search_config'),('search_config_table'),('search_implicit_criteria'),('search_result_enhancer'),('search_result_view'),('search_result_view_column'),('search_result_view_sort'),('search_sql_group'),('search_sql_groupby'),('search_result_formatter_params'),('search_table'),('search_table_column'),('search_table_relation'),('search_criteria_operator'),('search_skip_table');
  
END $$

-- Execute the stored procedure
CALL V20200729121121__data_config_app_skip_table $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200729121121__data_config_app_skip_table $$
 
DELIMITER ;