DELIMITER $$
DROP PROCEDURE IF EXISTS V20200729130319__Create_employeeJobPostingConfiguration $$
CREATE PROCEDURE V20200729130319__Create_employeeJobPostingConfiguration()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='employee_job_posting_configuration')) THEN 
CREATE TABLE `employee_job_posting_configuration` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `newModuleName` VARCHAR(255) NULL,
  `employeeJobPostingFormModuleId` BIGINT(20) NULL,
  `employeeJobPostingId` BIGINT(20) NULL,
  `visibility` BIT(1) NULL,
  `mandatory` BIT(1) NULL,
  `sequenceNo` INT(11) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_empl_job_form_module_idx` (`employeeJobPostingFormModuleId` ASC),
  INDEX `fk_empl_job_posting_id_idx` (`employeeJobPostingId` ASC) ,
  INDEX `fk_empl_last_updated_by_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_empl_job_form_module`
    FOREIGN KEY (`employeeJobPostingFormModuleId`)
    REFERENCES `employee_job_posting_form_modules` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_empl_job_posting_id`
    FOREIGN KEY (`employeeJobPostingId`)
    REFERENCES `employee_job_posting` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_empl_last_updated_by`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20200729130319__Create_employeeJobPostingConfiguration () $$ 
DROP PROCEDURE IF EXISTS V20200729130319__Create_employeeJobPostingConfiguration $$ 
DELIMITER ;
