DELIMITER $$
DROP PROCEDURE IF EXISTS V20200730144556__Create_customFieldConfigEmployeeJob $$
CREATE PROCEDURE V20200730144556__Create_customFieldConfigEmployeeJob()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='custom_field_config_employee_job')) THEN 
CREATE TABLE `custom_field_config_employee_job` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `employeeJobPostingId` bigint(20) DEFAULT NULL,
  `employeeJobFormModuleId` bigint(20) DEFAULT NULL,
  `customFieldConfigId` bigint(20) DEFAULT NULL,
  `whetherCustomField` bit(1) DEFAULT NULL,
  `isVisible` bit(1) DEFAULT NULL,
  `isMandatory` bit(1) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fkee_employ_job_posting_idx` (`employeeJobPostingId`),
  KEY `fkee_employ_form_mod_idx` (`employeeJobFormModuleId`),
  KEY `fkee_employ_last_updated_by_idx` (`lastUpdatedBy`),
  KEY `fkee_employ_custom_idx` (`customFieldConfigId`),
  CONSTRAINT `fkee_employ_custom` FOREIGN KEY (`customFieldConfigId`) REFERENCES `custom_field_config` (`id`),
  CONSTRAINT `fkee_employ_form_mod` FOREIGN KEY (`employeeJobFormModuleId`) REFERENCES `employee_job_posting_form_modules` (`id`),
  CONSTRAINT `fkee_employ_job_posting` FOREIGN KEY (`employeeJobPostingId`) REFERENCES `employee_job_posting` (`id`),
  CONSTRAINT `fkee_employ_last_updated_by` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ;

END IF; 

END $$
CALL V20200730144556__Create_customFieldConfigEmployeeJob () $$ 
DROP PROCEDURE IF EXISTS V20200730144556__Create_customFieldConfigEmployeeJob $$ 
DELIMITER ;