DELIMITER $$

DROP PROCEDURE IF EXISTS V20200806190155__InsertUITRNSForDocPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200806190155__InsertUITRNSForDocPortal()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='INVALID_VALUE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','INVALID_VALUE','Invalid Value','Invalid Value','Ongeldige waarde', 'Giá trị không hợp lệ',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='IS_REQUIRED')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','IS_REQUIRED','is required','is required','word benodig', 'bắt buộc',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DOCUMENT_NAME')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','DOCUMENT_NAME','Document Name','Document Name','Dokumentnaam', 'Tên tài liệu',now(),1);
END IF;


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PROGRAM_MAX_LIMIT_REACHED')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','PROGRAM_MAX_LIMIT_REACHED','Maximum program selection limit has been reached','Maximum program selection limit has been reached','Die maksimum limiet vir programkeuse is bereik', 'Đã đạt đến giới hạn lựa chọn chương trình tối đa',now(),1);
END IF;
 
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DOCUMENT_TYPE')) THEN 
update `ui_translation`
set defaultValue = 'Document Type',
customerDefineValue = 'Document Type',
afriLanguage = 'Dokumenttipe',
vietLanguage = 'loại tài liệu'
where objectName='PORTAL_SETUP_NEW' and keyName='DOCUMENT_TYPE';
END IF; 
SET SQL_SAFE_UPDATES=1;
 
END $$

-- Execute the stored procedure
CALL V20200806190155__InsertUITRNSForDocPortal $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200806190155__InsertUITRNSForDocPortal $$
 
DELIMITER ;