DELIMITER $$
DROP PROCEDURE IF EXISTS V20200820122738__Create_Manage_Attainment $$
CREATE PROCEDURE V20200820122738__Create_Manage_Attainment()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='manage_attainment') THEN 
CREATE TABLE `manage_attainment` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `batchId` BIGINT NOT NULL,
  `outcomesType` BIGINT NOT NULL,
  `indirectAttainmentWeightage` DOUBLE NOT NULL,
  `directAttainmentWeightage` DOUBLE NOT NULL,
  `referenceFileId` BIGINT  NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `FK_manage_attainment_batchId` (`batchId` ASC),
  INDEX `FK_manage_attainment_outcomesTypeId` (`outcomesType` ASC),
  INDEX `FK_manage_attainment_referenceFileId` (`referenceFileId` ASC),
  INDEX `FK_manage_attainment_lastUpdatedBy` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_manage_attainment_batchId`
	FOREIGN KEY (`batchId`)
	REFERENCES `batches` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_attainment_outComesType`
	FOREIGN KEY (`outcomesType`)
	REFERENCES `program_out_comes_type` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_attainment_rerenceFileId`
	FOREIGN KEY (`referenceFileId`)
	REFERENCES `documents` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_attainment_lastuUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION ON UPDATE NO ACTION);
END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='manage_program_outcomes' 
  AND column_name='indirectAttainment')) THEN 
  ALTER TABLE  `manage_program_outcomes` 
ADD COLUMN `indirectAttainment` DOUBLE NULL DEFAULT NULL AFTER `description`,
ADD COLUMN `manageAttainmentId` BIGINT NULL DEFAULT NULL AFTER `indirectAttainment`,
ADD INDEX `fk_manage_program_outcomes_manageArrainmentId_idx` (`manageAttainmentId`),
ADD CONSTRAINT `fk_manage_program_outcomes_manageAttainment_Id`
  FOREIGN KEY (`manageAttainmentId`)
  REFERENCES  `manage_attainment`(`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
END IF; 


END $$
CALL V20200820122738__Create_Manage_Attainment () $$ 
DROP PROCEDURE IF EXISTS V20200820122738__Create_Manage_Attainment $$ 
DELIMITER ;