DELIMITER $$
DROP PROCEDURE IF EXISTS V20200828113618__Create_registration_setup $$
CREATE PROCEDURE V20200828113618__Create_registration_setup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_profile_update')) THEN 
CREATE TABLE `term_wise_profile_update` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `registrationTermSetupDetailId` bigint(20) NOT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `isProfileUpdateApplicable` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_term_wise_profile_update_idx` (`registrationTermSetupDetailId`),
  CONSTRAINT `fk_term_wise_profile_update` 
  FOREIGN KEY (`registrationTermSetupDetailId`) 
  REFERENCES `registration_term_setup_detail` (`id`),
  KEY `fk_term_wise_profile_update_idx_1` (`lastUpdatedBy`),
  CONSTRAINT `fk_term_wise_profile_update_1` 
  FOREIGN KEY (`lastUpdatedBy`) 
  REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_profile_link')) THEN 
CREATE TABLE `term_wise_profile_link` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `termWiseProfileUpdateId` bigint(20) NOT NULL,
  `linkName` varchar(255) NOT NULL,
  `sequenceNo` INT NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_term_wise_profile_link_idx` (`termWiseProfileUpdateId`),
  CONSTRAINT `fk_term_wise_profile_link` 
  FOREIGN KEY (`termWiseProfileUpdateId`) 
  REFERENCES `term_wise_profile_update` (`id`),
  KEY `fk_term_wise_profile_link_idx_1` (`lastUpdatedBy`),
  CONSTRAINT `fk_term_wise_profile_link_1` 
  FOREIGN KEY (`lastUpdatedBy`) 
  REFERENCES `users` (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_profile_link')) THEN 
ALTER TABLE `term_wise_profile_link` 
ADD COLUMN `isSelected` BIT(1) NOT NULL DEFAULT b'1' AFTER `sequenceNo`;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_registration_document_setup')) THEN 
CREATE TABLE `term_wise_registration_document_setup` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `registrationTermSetupDetailId` bigint(20) NOT NULL,
  `isDocumentApplicable` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_term_wise_registration_document_setup_idx` (`registrationTermSetupDetailId`),
  KEY `fk_term_wise_registration_document_setup_idx_1` (`lastUpdatedBy`),
  CONSTRAINT `fk_term_wise_registration_document_setup` FOREIGN KEY (`registrationTermSetupDetailId`) REFERENCES `registration_term_setup_detail` (`id`),
  CONSTRAINT `fk_term_wise_registration_document_setup_1`  FOREIGN KEY (`lastUpdatedBy`)  REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_registration_document')) THEN 
CREATE TABLE `term_wise_registration_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `termWiseRegistrationDocumentSetupId` bigint(20) NOT NULL,
  `documentTypeId` bigint(20) NOT NULL,
  `isMandatory` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `term_wise_registration_document_idx` (`termWiseRegistrationDocumentSetupId`),
  KEY `term_wise_registration_document_idx_1` (`documentTypeId`),
  KEY `term_wise_registration_document_idx_2` (`lastUpdatedBy`),
  CONSTRAINT `fk_term_wise_registration_document` FOREIGN KEY (`termWiseRegistrationDocumentSetupId`) REFERENCES `term_wise_registration_document_setup` (`id`),
  CONSTRAINT `fk_term_wise_registration_document_1` FOREIGN KEY (`documentTypeId`) REFERENCES `document_types` (`id`),
  CONSTRAINT `fk_term_wise_registration_document_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='student_profile_link')) THEN 
CREATE TABLE `student_profile_link` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `linkName` varchar(255) NOT NULL,
  `sequenceNo` INT NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `student_profile_link_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_student_profile_link` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='student_profile_link')) THEN 
INSERT INTO `student_profile_link` (`id`, `linkName`, `sequenceNo`, `lastUpdatedBy`, `lastUpdate`) VALUES ('1', 'Personal', '1', '1', now());
INSERT INTO `student_profile_link` (`id`, `linkName`, `sequenceNo`, `lastUpdatedBy`, `lastUpdate`) VALUES ('2', 'Address', '2', '1', now());
INSERT INTO `student_profile_link` (`id`, `linkName`, `sequenceNo`, `lastUpdatedBy`, `lastUpdate`) VALUES ('3', 'Parents', '3', '1', now());
INSERT INTO `student_profile_link` (`id`, `linkName`, `sequenceNo`, `lastUpdatedBy`, `lastUpdate`) VALUES ('4', 'Fee Payer Details', '4', '1', now());
INSERT INTO `student_profile_link` (`id`, `linkName`, `sequenceNo`, `lastUpdatedBy`, `lastUpdate`) VALUES ('5', 'Siblings', '5', '1', now());
INSERT INTO `student_profile_link` (`id`, `linkName`, `sequenceNo`, `lastUpdatedBy`, `lastUpdate`) VALUES ('6', 'Education', '6', '1', now());
INSERT INTO `student_profile_link` (`id`, `linkName`, `sequenceNo`, `lastUpdatedBy`, `lastUpdate`) VALUES ('7', 'Competitive Exam', '7', '1', now());
INSERT INTO `student_profile_link` (`id`, `linkName`, `sequenceNo`, `lastUpdatedBy`, `lastUpdate`) VALUES ('8', 'Work Experience', '8', '1', now());
INSERT INTO `student_profile_link` (`id`, `linkName`, `sequenceNo`, `lastUpdatedBy`, `lastUpdate`) VALUES ('9', 'Medical Conditions', '9', '1', now());
INSERT INTO `student_profile_link` (`id`, `linkName`, `sequenceNo`, `lastUpdatedBy`, `lastUpdate`) VALUES ('10', 'Vaccination', '10', '1', now());
INSERT INTO `student_profile_link` (`id`, `linkName`, `sequenceNo`, `lastUpdatedBy`, `lastUpdate`) VALUES ('11', 'Extracurricular', '11', '1', now());
END IF; 

END $$
CALL V20200828113618__Create_registration_setup () $$ 
DROP PROCEDURE IF EXISTS V20200828113618__Create_registration_setup $$ 
DELIMITER ;