DELIMITER $$
DROP PROCEDURE IF EXISTS V20201007102658__Create_Exam_Cancellation_Request $$
CREATE PROCEDURE V20201007102658__Create_Exam_Cancellation_Request()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_cancellation_request')) THEN 
CREATE TABLE `exam_cancellation_request` (
    `id` BIGINT NOT NULL AUTO_INCREMENT,
    `admissionId` BIGINT NOT NULL,
    `courseId` BIGINT NOT NULL,
    `batchId` BIGINT NOT NULL,
    `periodId` BIGINT NOT NULL,
    `examCancellationRequestDate` DATE NOT NULL,
    `documentId` BIGINT NULL,
    `remark` TEXT NOT NULL,
    PRIMARY KEY (`id`),
    `lastUpdatedBy` BIGINT(20) NOT NULL,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `fk_exam_cancellation_request_1_idx` (`documentid` ASC),
    CONSTRAINT `fk_exam_cancellation_request_1` FOREIGN KEY (`documentId`)
        REFERENCES `documents` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION
);
END IF; 

END $$
CALL V20201007102658__Create_Exam_Cancellation_Request () $$ 
DROP PROCEDURE IF EXISTS V20201007102658__Create_Exam_Cancellation_Request $$ 
DELIMITER ;