DELIMITER $$
DROP PROCEDURE IF EXISTS V20201010174050__CreateNewPortalLastTxn $$
CREATE PROCEDURE V20201010174050__CreateNewPortalLastTxn()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='portal_setup_last_txn')) THEN 
CREATE TABLE `portal_setup_last_txn` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `application_id` bigint(20) NOT NULL,
  `sequence` bigint(20) NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_portal_setup_last_txn` (`application_id`),
  KEY `FK_FK_portal_setup_last_txn_users` (`lastUpdatedBy`),
  CONSTRAINT `FK_portal_setup_last_txn_application` FOREIGN KEY (`application_id`) REFERENCES `application` (`id`),
  CONSTRAINT `FK_FK_portal_setup_last_txn_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20201010174050__CreateNewPortalLastTxn () $$ 
DROP PROCEDURE IF EXISTS V20201010174050__CreateNewPortalLastTxn $$ 
DELIMITER ;