DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_programsubjectdetails //
CREATE  PROCEDURE sp_tvet_programsubjectdetails()
BEGIN

select distinct
educationDepartmentProgramCode as ProgrammeCode,  
cou.courseCode as Subject_Code,
DATE_FORMAT(b.startDate, '%Y%m%d') as Prog_Subj_Start_Date,
DATE_FORMAT(b.tillDate, '%Y%m%d') as Prog_Subj_End_Date,
al.locationCode as Provider_Code,
'541' Provider_ETQE_Id,  
CASE WHEN cou.whetherDeleted = 0 then 1 ELSE 2 end as Subject_Status_Id ,
cou.courseCredits as Subject_Credit,
cou.subjectTypeId as Prog_Subj_Type_Id,
DATE_FORMAT(NOW(), '%Y%m%d') as Date_Stamp
from
   program_courses pc 
 left join
 batches b on pc.programBatchId = b.id 
 left join
programs p on b.programId = p.id
left join
academy_location al on al.id = p.academyLocationId
left join
affiliated_university au on au.id = p.affiliatedUniversityId
left join
prog_batch_period_config per on  per.programbatchId = b.id
left join
courses cou on cou.id = pc.courseId
where
  year(now()) between year(b.startDate) and year(b.tillDate)
  group by cou.id, al.id, p.id, b.startDate;
  

END//
DELIMITER ;