DELIMITER $$
DROP PROCEDURE IF EXISTS V20201102161051__Create_MealTypeCSM $$
CREATE PROCEDURE V20201102161051__Create_MealTypeCSM()
BEGIN


IF NOT EXISTS (( SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='meal_type_csm')) THEN 
CREATE TABLE `meal_type_csm` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mealTypeCode` varchar(100) DEFAULT NULL,
  `mealTypeName` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_meal_type_csm` (`lastUpdatedBy`),
  CONSTRAINT `fk_meal_type_csm` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'MEAL_TYPE_CSM')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'meal_type_csm','MEAL_TYPE_CSM','Hostel','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;


IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'meal_type_csm');
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('mealTypeCode','MEAL_TYPE_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('mealTypeName','MEAL_TYPE_NAME',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

END IF; 

-- add column in hostel_room_allotment table
IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='hostel_room_allotment' AND column_name='mealTypeCSMId')) THEN 
  ALTER TABLE `hostel_room_allotment` 
  ADD COLUMN `mealTypeCSMId` BIGINT(20) NULL DEFAULT NULL;
  
    ALTER TABLE `hostel_room_allotment` 
	ADD CONSTRAINT `fk_hostel_room_allotment_meal_type_csm`
	FOREIGN KEY (`mealTypeCSMId`)
	REFERENCES `meal_type_csm` (`id`)
	ON DELETE RESTRICT
	ON UPDATE RESTRICT;

END IF;

-- translations

   IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'MEAL_TYPE_CSM')) THEN 
		INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
		VALUES ('masterNames', 'MEAL_TYPE_CSM', 'Meal Type', 'Meal Type','Maaltyd tipe','Loại bữa ăn',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'MEAL_TYPE_CODE')) THEN 
		INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
		VALUES ('TRANSLATIONS', 'MEAL_TYPE_CODE', 'Meal Type Code', 'Meal Type Code','Maaltydkode','Mã loại bữa ăn',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'MEAL_TYPE_NAME')) THEN 
		INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
		VALUES ('TRANSLATIONS', 'MEAL_TYPE_NAME', 'Meal Type Name', 'Meal Type Name','Maaltydnaam','Tên loại bữa ăn',now(),1);
	END IF;

END $$
CALL V20201102161051__Create_MealTypeCSM () $$ 
DROP PROCEDURE IF EXISTS V20201102161051__Create_MealTypeCSM $$ 
DELIMITER ;