DELIMITER $$
DROP PROCEDURE IF EXISTS V20201106122540__Create_disciplinaryAppealDetails $$
CREATE PROCEDURE V20201106122540__Create_disciplinaryAppealDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='appeal_details_su')) THEN 
CREATE TABLE `appeal_details_su` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `disciplinaryActionId` bigint DEFAULT NULL,
  `appealDate` datetime DEFAULT NULL,
  `appealOutcomeId` bigint DEFAULT NULL,
  `misConductDetails` longtext,
  `remarks` longtext,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_appeal_detail_su_disc_action_idx` (`disciplinaryActionId`),
  KEY `fk_appeal_detail_appeal_out_idx` (`appealOutcomeId`),
  KEY `fk_appeal_detail_lst_updated_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_appeal_detail_appeal_out` FOREIGN KEY (`appealOutcomeId`) REFERENCES `appeal_outcome` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_appeal_detail_lst_updated` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_appeal_detail_su_disc_action` FOREIGN KEY (`disciplinaryActionId`) REFERENCES `disciplinary_actions_su` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20201106122540__Create_disciplinaryAppealDetails () $$ 
DROP PROCEDURE IF EXISTS V20201106122540__Create_disciplinaryAppealDetails $$ 
DELIMITER ;