DELIMITER $$
DROP PROCEDURE IF EXISTS V20201110153921__Create_CourseFeeDefination $$
CREATE PROCEDURE V20201110153921__Create_CourseFeeDefination()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_fee_defination')) THEN 
CREATE TABLE `course_fee_defination` (
  `id` BIGINT NOT NULL,
  `courseId` BIGINT NOT NULL,
  `departmentId` BIGINT NOT NULL,
  `courseDefinationName` VARCHAR(255) NOT NULL,
  `parentFeeHeadId` BIGINT NOT NULL,
  `courseFeeType` VARCHAR(255) NOT NULL,
  `isActive` BIT(1) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_course_fee_defination_to_courses_idx` (`courseId` ASC) VISIBLE,
  INDEX `fk_course_fee_defination_to_department_idx` (`departmentId` ASC) VISIBLE,
  INDEX `fk_course_fee_defination_to_fee_head_idx` (`parentFeeHeadId` ASC) VISIBLE,
  INDEX `fk_course_fee_defination_to_user_idx` (`lastUpdatedBy` ASC) VISIBLE,
  CONSTRAINT `fk_course_fee_defination_to_courses`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_fee_defination_to_department`
    FOREIGN KEY (`departmentId`)
    REFERENCES `department` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_fee_defination_to_fee_head`
    FOREIGN KEY (`parentFeeHeadId`)
    REFERENCES `fee_heads` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_fee_defination_to_user`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF; 

END $$
CALL V20201110153921__Create_CourseFeeDefination () $$ 
DROP PROCEDURE IF EXISTS V20201110153921__Create_CourseFeeDefination $$ 
DELIMITER ;