DELIMITER $$
DROP PROCEDURE IF EXISTS V20201119131130__Create_StudentPeriodEnrollmentTable $$
CREATE PROCEDURE V20201119131130__Create_StudentPeriodEnrollmentTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='student_period_enrollment')) THEN 
CREATE TABLE `student_period_enrollment`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`studentId` BIGINT(20) NOT NULL,
	`periodId` BIGINT(20) NOT NULL,
	`status` VARCHAR(50) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	CONSTRAINT `fk_student_period_1` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`),
	CONSTRAINT `fk_student_period_2` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config`(`id`),
	CONSTRAINT `fk_student_period_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);
END IF; 

END $$
CALL V20201119131130__Create_StudentPeriodEnrollmentTable () $$ 
DROP PROCEDURE IF EXISTS V20201119131130__Create_StudentPeriodEnrollmentTable $$ 
DELIMITER ;