DELIMITER $$
DROP PROCEDURE IF EXISTS V20201217103714__Create_AppAdmConditionDetailTable $$
CREATE PROCEDURE V20201217103714__Create_AppAdmConditionDetailTable()
BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='app_program_adm_details')) THEN 
		
		CREATE TABLE `app_program_adm_details`( 
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
		`applicationProgramId` BIGINT(20) NOT NULL,
		`offerType` VARCHAR(20) NULL DEFAULT NULL,
		`conditionApplicable` BIT(1) NULL DEFAULT NULL,
		`additionalCondition` TEXT NULL DEFAULT NULL,
    	`escalationRequired` BIT(1) NULL DEFAULT NULL,
		`conditionSatisfactionDate` DATE NULL DEFAULT NULL,
		`escalationComments` TEXT NULL DEFAULT NULL,
		`approvalRequiredBy` BIT(1) NULL DEFAULT NULL,
		`reviewerId` bigint(20) DEFAULT NULL,
		`lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
		`lastUpdatedBy` BIGINT(20),
		PRIMARY KEY (`id`), 
		CONSTRAINT `app_program_adm_details_applicationProgramId_FK` FOREIGN KEY (`applicationProgramId`) REFERENCES `application_program`(`id`),
		CONSTRAINT `app_program_adm_details_reviewerId_FK` FOREIGN KEY (`reviewerId`) REFERENCES `users`(`id`),
		CONSTRAINT `app_program_adm_details_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`))
		ENGINE=INNODB DEFAULT  CHARSET=utf8; 
	
	END IF; 
	
END $$
CALL V20201217103714__Create_AppAdmConditionDetailTable () $$ 
DROP PROCEDURE IF EXISTS V20201217103714__Create_AppAdmConditionDetailTable $$ 
DELIMITER ;
