DELIMITER $$
DROP PROCEDURE IF EXISTS V20201221184317__Create_ProgramBatchPeriodCourseFee $$
CREATE PROCEDURE V20201221184317__Create_ProgramBatchPeriodCourseFee()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='prog_batch_period_course_fee')) THEN 
CREATE TABLE `prog_batch_period_course_fee` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `parentFeeHeadId` bigint NOT NULL,
  `courseFeeType` varchar(255) NOT NULL,
  `isActive` bit(1) NOT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_prog_batch_period_course_fee_to_fee_head_idx` (`parentFeeHeadId`),
  KEY `fk_prog_batch_period_course_fee_to_user_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_prog_batch_period_course_fee_to_fee_head` FOREIGN KEY (`parentFeeHeadId`) REFERENCES `fee_heads` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_prog_batch_period_course_fee_to_user` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20201221184317__Create_ProgramBatchPeriodCourseFee () $$ 
DROP PROCEDURE IF EXISTS V20201221184317__Create_ProgramBatchPeriodCourseFee $$ 
DELIMITER ;