DELIMITER $$
DROP PROCEDURE IF EXISTS V20201224171834__Alter_election_list_candidate $$
CREATE PROCEDURE V20201224171834__Alter_election_list_candidate()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='election_list_candidate'  AND column_name in ('departmentId','programId'))) THEN 

ALTER TABLE `election_list_candidate` 
ADD COLUMN `programId` BIGINT(20) NULL AFTER `candidateStatement`,
ADD COLUMN `departmentId` BIGINT(20) NULL AFTER `programId`,
ADD INDEX `fk_elc_list_candidate_prog_id_idx` (`programId` ASC) VISIBLE,
ADD INDEX `fk_elc_list_candidate_dept_id_idx` (`departmentId` ASC) VISIBLE;
ALTER TABLE `election_list_candidate` 
ADD CONSTRAINT `fk_elc_list_candidate_prog_id`
  FOREIGN KEY (`programId`)
  REFERENCES `programs` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_elc_list_candidate_dept_id`
  FOREIGN KEY (`departmentId`)
  REFERENCES `department` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

END IF; 

END $$
CALL V20201224171834__Alter_election_list_candidate() $$
DROP PROCEDURE IF EXISTS V20201224171834__Alter_election_list_candidate $$
DELIMITER ;