DELIMITER $$

DROP PROCEDURE IF EXISTS V202012292315__Insert_CreditBasedTranslation $$

CREATE PROCEDURE V202012292315__Insert_CreditBasedTranslation()

BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'TOTAL_COURSES_ENROLLED' and  objectName ='TRANSLATIONS')) THEN
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS','TOTAL_COURSES_ENROLLED','Total Courses Enrolled','Total Courses Enrolled','Totale kursusse ingeskryf','Tổng số khóa học đã đăng ký',now(),1);
END IF;
 
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'TOTAL_COURSES_PASSED' and  objectName ='TRANSLATIONS')) THEN
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS','TOTAL_COURSES_PASSED','Total Courses Passed','Total Courses Passed','Totale kursusse geslaag','Tổng số khóa học đã vượt qua',now(),1);
END IF;


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'TOTAL_CREDITS_OFFERED' and  objectName ='TRANSLATIONS')) THEN
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS','TOTAL_CREDITS_OFFERED','Total Credits Offered','Total Credits Offered','Totale krediete aangebied','Tổng số tín dụng được cung cấp',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'TOTAL_CREDITS_EARNED' and  objectName ='TRANSLATIONS')) THEN
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS','TOTAL_CREDITS_EARNED','Total Credits Earned','Total Credits Earned','Totale krediete verdien','Tổng số tín dụng đã kiếm được',now(),1);
END IF;



END $$

CALL V202012292315__Insert_CreditBasedTranslation() $$

DROP PROCEDURE IF EXISTS V202012292315__Insert_CreditBasedTranslation $$

DELIMITER ;