DELIMITER $$
DROP PROCEDURE IF EXISTS V20210105175425__Insert_ElectionStudentsConfigLoader $$
CREATE PROCEDURE V20210105175425__Insert_ElectionStudentsConfigLoader()
BEGIN

IF NOT EXISTS ((SELECT * FROM `import_utility_master` WHERE screenName = 'Voter Pool - Students / Staff' and  code ='Voter Pool-Student')) THEN 
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`)
 VALUES ('Voter Pool - Students / Staff', 'election/Staff_voterpool', 'Voter Pool-Student', '1');
END IF; 

	
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ELE_ELECTION_NAME_CODE_HEADER' and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ELE_ELECTION_NAME_CODE_HEADER' , 'Election Code / Name' , 0,  sysdate()  , 1 , 'Election Code / Name' , 1, 1 , ( select id from import_utility_master where code = 'Voter Pool-Student' ) );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'VOTER_POOL_TYPE' and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'VOTER_POOL_TYPE' , 'Voter Pool Type' , 0,  sysdate()  , 1 , 'Voter Pool Type' , 1, 1 , ( select id from import_utility_master where code = 'Voter Pool-Student' ) );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'STUDENT_USER_ID' and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'STUDENT_USER_ID' , 'Student ID / User ID' , 0,  sysdate()  , 1 , 'Student ID / User ID' , 1, 1 , ( select id from import_utility_master where code = 'Voter Pool-Student' ) ); 
END IF;


END $$
CALL V20210105175425__Insert_ElectionStudentsConfigLoader() $$
DROP PROCEDURE IF EXISTS V20210105175425__Insert_ElectionStudentsConfigLoader $$
DELIMITER ;