DELIMITER $$
DROP PROCEDURE IF EXISTS V20210107175947__Alter_EdHistoryAddAddressFields $$
CREATE PROCEDURE V20210107175947__Alter_EdHistoryAddAddressFields()

BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='education_histories' AND column_name='country_id')) THEN 
	ALTER TABLE `education_histories` 
	ADD COLUMN `country_id` BIGINT(20) NULL DEFAULT NULL after education_department_id,
	ADD CONSTRAINT `fk_education_histories_country_id` 
	FOREIGN KEY (`country_id`) REFERENCES `country` (`id`);
	END IF; 
	
	
	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='education_histories' AND column_name='country_region_id')) THEN 
	ALTER TABLE `education_histories` 
	ADD COLUMN `country_region_id` BIGINT(20) NULL DEFAULT NULL after country_id,
	ADD CONSTRAINT `fk_education_histories_country_region_id` 
	FOREIGN KEY (`country_region_id`) REFERENCES `country_region` (`id`);
	END IF; 
	
	
	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='education_histories' AND column_name='city_id')) THEN 
	ALTER TABLE `education_histories` 
	ADD COLUMN `city_id` BIGINT(20) NULL DEFAULT NULL after country_region_id,
	ADD CONSTRAINT `fk_education_histories_city_id` 
	FOREIGN KEY (`city_id`) REFERENCES `city` (`id`);
	END IF; 

END $$

CALL V20210107175947__Alter_EdHistoryAddAddressFields() $$
DROP PROCEDURE IF EXISTS V20210107175947__Alter_EdHistoryAddAddressFields $$
DELIMITER ;