DELIMITER $$
DROP PROCEDURE IF EXISTS V20210118124012__Insert_PlacementFollowUpJasperReport $$
CREATE PROCEDURE V20210118124012__Insert_PlacementFollowUpJasperReport()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_type` WHERE typeName = 'Placement Follow Up Report' )) THEN
INSERT INTO `report_type` (`typeName`) VALUES ('Placement Follow Up Report'); 
END IF; 
	
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'PLACEMENT_FOLLOWUP_DETAILS_REPORT' )) THEN 
set @contact = (select id from report_type WHERE typeName = 'Placement Follow Up Report');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES (@contact, 'PLACEMENT_FOLLOWUP_DETAILS_REPORT', 'Placement Follow Up', 'PLACEMENT_FOLLOWUP_DETAILS_REPORT.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Header_Excel_Blank.jasper', '1', '1', 'PLACEMENT_FOLLOWUP_DETAILS_REPORT.jasper', 'AcademiaLogo.png'); 
END IF;


set @details = (select id from report_template where templateCode ='PLACEMENT_FOLLOWUP_DETAILS_REPORT');
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_PROJECT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_PROJECT_NAME', 'Project Name', '1', now());
 END IF;
 
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_PROGRAMMES')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_PROGRAMMES', 'Programmes', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_ALLOCATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_ALLOCATION', 'Allocation', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_START_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_START_DATE', 'Start Date', '1', now());
 END IF;

 IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_FINISH_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_FINISH_DATE', 'Finish Date', '1', now());
 END IF;

 
 IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_NEXT_REPORT_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_NEXT_REPORT_DATE', 'Next Report date', '1', now());
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_STATUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_STATUS', 'Status', '1', now());
 END IF;
 
 
END $$
CALL V20210118124012__Insert_PlacementFollowUpJasperReport() $$
DROP PROCEDURE IF EXISTS V20210118124012__Insert_PlacementFollowUpJasperReport $$
DELIMITER ;