DELIMITER $$
DROP PROCEDURE IF EXISTS V20210512115926__Create_examConcession $$
CREATE PROCEDURE V20210512115926__Create_examConcession()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_concession' )) THEN 
CREATE TABLE `exam_concession` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `examConcessionCode` VARCHAR(255) NOT NULL,
  `examConcessionName` VARCHAR(255) NOT NULL,
  `status` VARCHAR(100) NOT NULL,
  `dependentFieldRequired` BIT(1) NULL DEFAULT b'0',
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `examConcession_lastUpdateBy` (`lastUpdatedBy` ASC) ,
  CONSTRAINT `exam_concession_lastUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210512115926__Create_examConcession () $$ 
DROP PROCEDURE IF EXISTS V20210512115926__Create_examConcession $$ 
DELIMITER ;