DELIMITER $$
DROP PROCEDURE IF EXISTS V20210521141411__Insert_ConfigureLoaderForStudentRemoveHolds $$
CREATE PROCEDURE V20210521141411__Insert_ConfigureLoaderForStudentRemoveHolds()
BEGIN

IF NOT EXISTS ((SELECT * FROM `import_utility_master` WHERE screenName = 'Bulk Remove Hold' and  code ='Bulk Remove Hold')) THEN 
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`)
 VALUES ('Bulk Remove Hold', 'hold/RemoveHold', 'Bulk Remove Hold', '1');
END IF; 

SET @importMasterId=(select id from import_utility_master where code = 'Bulk Remove Hold' );

	
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'Student_ID_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'Student_ID_HEADER' , 'Student Id' , 0,  sysdate()  , 1 , 'Student Id' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'STUDENT_NAME_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'STUDENT_NAME_HEADER' , 'Student Name' , 0,  sysdate()  , 1 , 'Student Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'MANAGE_HOLD_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'MANAGE_HOLD_HEADER' , 'Hold Category Name' , 0,  sysdate()  , 1 , 'Hold Category Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'MANAGE_SUB_HOLD_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'MANAGE_SUB_HOLD_HEADER' , 'Hold Sub Category Code/Name' , 0,  sysdate()  , 1 , 'Hold Sub Category Code/Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'REMOVED_BY_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'REMOVED_BY_HEADER' , 'Removed By ' , 0,  sysdate()  , 1 , 'Removed By ' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'REASON_TO_REMOVE_HOLD_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'REASON_TO_REMOVE_HOLD_HEADER' , 'Reason to Remove Hold' , 0,  sysdate()  , 1 , 'Reason to Remove Hold' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'REMOVED_DATE_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'REMOVED_DATE_HEADER' , 'Removal Date' , 0,  sysdate()  , 1 , 'Removal Date' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'STUDENT_APPLAY_HOLD_CAT_ID'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`) 
VALUES (  'STUDENT_APPLAY_HOLD_CAT_ID' , 'ID' , 0,  sysdate()  , 1 , 'ID' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Remove Hold'),0 );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'Student_ID_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'Student_ID_HEADER' , 'Student Id' , 1,  sysdate()  , 1 , 'Student Id' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'STUDENT_NAME_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'STUDENT_NAME_HEADER' , 'Student Name' , 1,  sysdate()  , 1 , 'Student Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'MANAGE_HOLD_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'MANAGE_HOLD_HEADER' , 'Hold Category Name' , 1,  sysdate()  , 1 , 'Hold Category Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'MANAGE_SUB_HOLD_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'MANAGE_SUB_HOLD_HEADER' , 'Hold Sub Category Code/Name' , 1,  sysdate()  , 1 , 'Hold Sub Category Code/Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'REMOVED_BY_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'REMOVED_BY_HEADER' , 'Removed By ' , 1,  sysdate()  , 1 , 'Removed By ' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'REASON_TO_REMOVE_HOLD_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'REASON_TO_REMOVE_HOLD_HEADER' , 'Reason to Remove Hold' , 1,  sysdate()  , 1 , 'Reason to Remove Hold' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'REMOVED_DATE_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'REMOVED_DATE_HEADER' , 'Removal Date' , 1,  sysdate()  , 1 , 'Removal Date' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Remove Hold') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'STUDENT_APPLAY_HOLD_CAT_ID'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`) 
VALUES (  'STUDENT_APPLAY_HOLD_CAT_ID' , 'ID' , 1,  sysdate()  , 1 , 'ID' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Remove Hold'),0 );
END IF;

END $$
CALL V20210521141411__Insert_ConfigureLoaderForStudentRemoveHolds() $$
DROP PROCEDURE IF EXISTS V20210521141411__Insert_ConfigureLoaderForStudentRemoveHolds $$
DELIMITER ;