DELIMITER $$
DROP PROCEDURE IF EXISTS V20210607102611__Insert_ConfigLoaderFDManagement $$
CREATE PROCEDURE V20210607102611__Insert_ConfigLoaderFDManagement()
BEGIN

IF NOT EXISTS ((SELECT * FROM `import_utility_master` WHERE screenName = 'Bulk Inward Item' and  code ='Bulk Inward Item')) THEN 
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`)
 VALUES ('Bulk Inward Item', 'inward/InwardItem', 'Bulk Inward Item', '1');
END IF; 

SET @importMasterId=(select id from import_utility_master where code = 'Bulk Inward Item' );

	
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ENTRY_TYPE_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ENTRY_TYPE_HEADER' , 'Entry Type' , 0,  sysdate()  , 1 , 'Entry Type' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ITEM_CATEGORY_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ITEM_CATEGORY_HEADER' , 'Item Category' , 0,  sysdate()  , 1 , 'Item Category' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SENDER_NAME_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SENDER_NAME_HEADER' , 'Sender Name' , 0,  sysdate()  , 1 , 'Sender Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CELL_COUNTRY_CODE_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CELL_COUNTRY_CODE_HEADER' , 'Cell Country Code Sender' , 0,  sysdate()  , 1 , 'Cell Country Code Sender' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SENDER_CONTACT_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SENDER_CONTACT_NUMBER_HEADER' , 'Sender Contact Number' , 0,  sysdate()  , 1 , 'Sender Contact Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'RECEIVER_NAME_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'RECEIVER_NAME_HEADER' , 'Receiver Name' , 0,  sysdate()  , 1 , 'Receiver Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CELL_COUNTRY_CODE_HEADER2'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CELL_COUNTRY_CODE_HEADER2' , 'Cell Country Code Receiver' , 0,  sysdate()  , 1 , 'Cell Country Code Receiver' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'RECEIVER_CONTACT_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'RECEIVER_CONTACT_NUMBER_HEADER' , 'Receiver  Contact Number' , 0,  sysdate()  , 1 , 'Receiver  Contact Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'INWARD_ENTRY_BY_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'INWARD_ENTRY_BY_HEADER' , 'Inward Entry By' , 0,  sysdate()  , 1 , 'Inward Entry By' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SERVICE_PROVIDER_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SERVICE_PROVIDER_HEADER' , 'Service Provider' , 0,  sysdate()  , 1 , 'Service Provider' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'DOCKET_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'DOCKET_NUMBER_HEADER' , 'Docket Number' , 0,  sysdate()  , 1 , 'Docket Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'RECEIVING_DATE_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'RECEIVING_DATE_HEADER' , 'Receiving Date' , 0,  sysdate()  , 1 , 'Receiving Date' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'BILL_NO_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'BILL_NO_HEADER' , 'Bill No.' , 0,  sysdate()  , 1 , 'Bill No.' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'BILL_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'BILL_NUMBER_HEADER' , 'Bill Number' , 0,  sysdate()  , 1 , 'Bill Number' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'BILL_AMOUNT_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'BILL_AMOUNT_HEADER' , 'Bill Amount' , 0,  sysdate()  , 1 , 'Bill Amount' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'REMARK_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'REMARK_HEADER' , 'Remark' , 0,  sysdate()  , 1 , 'Remark' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item'));
END IF;




IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ENTRY_TYPE_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ENTRY_TYPE_HEADER' , 'Entry Type' , 1,  sysdate()  , 1 , 'Entry Type' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ITEM_CATEGORY_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ITEM_CATEGORY_HEADER' , 'Item Category' , 1,  sysdate()  , 1 , 'Item Category' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SENDER_NAME_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SENDER_NAME_HEADER' , 'Sender Name' , 1,  sysdate()  , 1 , 'Sender Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CELL_COUNTRY_CODE_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CELL_COUNTRY_CODE_HEADER' , 'Cell Country Code Sender' , 1,  sysdate()  , 1 , 'Cell Country Code Sender' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SENDER_CONTACT_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SENDER_CONTACT_NUMBER_HEADER' , 'Sender Contact Number' , 1,  sysdate()  , 1 , 'Sender Contact Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'RECEIVER_NAME_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'RECEIVER_NAME_HEADER' , 'Receiver Name' , 1,  sysdate()  , 1 , 'Receiver Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CELL_COUNTRY_CODE_HEADER2'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CELL_COUNTRY_CODE_HEADER2' , 'Cell Country Code Receiver' , 1,  sysdate()  , 1 , 'Cell Country Code Receiver' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'RECEIVER_CONTACT_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'RECEIVER_CONTACT_NUMBER_HEADER' , 'Receiver  Contact Number' , 1,  sysdate()  , 1 , 'Receiver  Contact Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'INWARD_ENTRY_BY_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'INWARD_ENTRY_BY_HEADER' , 'Inward Entry By' , 1,  sysdate()  , 1 , 'Inward Entry By' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SERVICE_PROVIDER_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SERVICE_PROVIDER_HEADER' , 'Service Provider' , 1,  sysdate()  , 1 , 'Service Provider' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'DOCKET_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'DOCKET_NUMBER_HEADER' , 'Docket Number' , 1,  sysdate()  , 1 , 'Docket Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'RECEIVING_DATE_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'RECEIVING_DATE_HEADER' , 'Receiving Date' , 1,  sysdate()  , 1 , 'Receiving Date' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'BILL_NO_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'BILL_NO_HEADER' , 'Bill No.' , 1,  sysdate()  , 1 , 'Bill No.' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'BILL_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'BILL_NUMBER_HEADER' , 'Bill Number' , 1,  sysdate()  , 1 , 'Bill Number' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'BILL_AMOUNT_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'BILL_AMOUNT_HEADER' , 'Bill Amount' , 1,  sysdate()  , 1 , 'Bill Amount' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'REMARK_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'REMARK_HEADER' , 'Remark' , 1,  sysdate()  , 1 , 'Remark' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Inward Item') );
END IF;



-- Outward Item 

IF NOT EXISTS ((SELECT * FROM `import_utility_master` WHERE screenName = 'Bulk Outward Item' and  code ='Bulk Outward Item')) THEN 
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`)
 VALUES ('Bulk Outward Item', 'outward/OutwardItem', 'Bulk Outward Item', '1');
END IF; 

SET @importMasterId2=(select id from import_utility_master where code = 'Bulk Outward Item' );


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ENTRY_TYPE_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ENTRY_TYPE_HEADER' , 'Entry Type' , 0,  sysdate()  , 1 , 'Entry Type' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ITEM_CATEGORY_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ITEM_CATEGORY_HEADER' , 'Item Category' , 0,  sysdate()  , 1 , 'Item Category' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SENDER_NAME_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SENDER_NAME_HEADER' , 'Sender Name' , 0,  sysdate()  , 1 , 'Sender Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CELL_COUNTRY_CODE_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CELL_COUNTRY_CODE_HEADER' , 'Cell Country Code Sender' , 0,  sysdate()  , 1 , 'Cell Country Code Sender' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SENDER_CONTACT_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SENDER_CONTACT_NUMBER_HEADER' , 'Sender Contact Number' , 0,  sysdate()  , 1 , 'Sender Contact Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'DELIVER_TO_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'DELIVER_TO_HEADER' , 'Deliver To' , 0,  sysdate()  , 1 , 'Deliver To' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CELL_COUNTRY_CODE_HEADER2'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CELL_COUNTRY_CODE_HEADER2' , 'Cell Country Code Receiver' , 0,  sysdate()  , 1 , 'Cell Country Code Receiver' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'RECEIVER_CONTACT_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'RECEIVER_CONTACT_NUMBER_HEADER' , 'Receiver Contact Number' , 0,  sysdate()  , 1 , 'Receiver Contact Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'DELIVERY_ADDRESS_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'DELIVERY_ADDRESS_HEADER' , 'Delivery Address' , 0,  sysdate()  , 1 , 'Delivery Address' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'OUTWARD_ENTRY_BY_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'OUTWARD_ENTRY_BY_HEADER' , 'Outward Entry By' , 0,  sysdate()  , 1 , 'Outward Entry By' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SERVICE_PROVIDER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SERVICE_PROVIDER_HEADER' , 'Service Provider' , 0,  sysdate()  , 1 , 'Service Provider' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'INTERNAL_PACKET_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'INTERNAL_PACKET_NUMBER_HEADER' , 'Internal Packet Number' , 0,  sysdate()  , 1 , 'Internal Packet Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'DOCKET_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'DOCKET_NUMBER_HEADER' , 'Docket Number' , 0,  sysdate()  , 1 , 'Docket Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SENT_DATE_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SENT_DATE_HEADER' , 'Sent Date' , 0,  sysdate()  , 1 , 'Sent Date' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ITEM_INSURED_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ITEM_INSURED_HEADER' , 'Item Insured' , 0,  sysdate()  , 1 , 'Item Insured' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'INSURED_BY_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'INSURED_BY_HEADER' , 'Insured By' , 0,  sysdate()  , 1 , 'Insured By' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'POLICY_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'POLICY_NUMBER_HEADER' , 'Policy Number ' , 0,  sysdate()  , 1 , 'Policy Number ' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'INSURANCE_AMOUNT_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'INSURANCE_AMOUNT_HEADER' , 'Insurance Amount' , 0,  sysdate()  , 1 , 'Insurance Amount' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'REMARK_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'REMARK_HEADER' , 'Remark' , 0,  sysdate()  , 1 , 'Remark' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;



IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ENTRY_TYPE_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ENTRY_TYPE_HEADER' , 'Entry Type' , 1,  sysdate()  , 1 , 'Entry Type' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ITEM_CATEGORY_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ITEM_CATEGORY_HEADER' , 'Item Category' , 1,  sysdate()  , 1 , 'Item Category' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SENDER_NAME_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SENDER_NAME_HEADER' , 'Sender Name' , 1,  sysdate()  , 1 , 'Sender Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;



IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CELL_COUNTRY_CODE_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CELL_COUNTRY_CODE_HEADER' , 'Cell Country Code Sender' , 1,  sysdate()  , 1 , 'Cell Country Code Sender' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SENDER_CONTACT_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SENDER_CONTACT_NUMBER_HEADER' , 'Sender Contact Number' , 1,  sysdate()  , 1 , 'Sender Contact Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'DELIVER_TO_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'DELIVER_TO_HEADER' , 'Deliver To' , 1,  sysdate()  , 1 , 'Deliver To' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CELL_COUNTRY_CODE_HEADER2'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CELL_COUNTRY_CODE_HEADER2' , 'Cell Country Code Receiver' , 1,  sysdate()  , 1 , 'Cell Country Code Receiver' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'RECEIVER_CONTACT_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'RECEIVER_CONTACT_NUMBER_HEADER' , 'Receiver Contact Number' , 1,  sysdate()  , 1 , 'Receiver Contact Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'DELIVERY_ADDRESS_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'DELIVERY_ADDRESS_HEADER' , 'Delivery Address' , 1,  sysdate()  , 1 , 'Delivery Address' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'OUTWARD_ENTRY_BY_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'OUTWARD_ENTRY_BY_HEADER' , 'Outward Entry By' , 1,  sysdate()  , 1 , 'Outward Entry By' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SERVICE_PROVIDER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SERVICE_PROVIDER_HEADER' , 'Service Provider' , 1,  sysdate()  , 1 , 'Service Provider' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'INTERNAL_PACKET_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'INTERNAL_PACKET_NUMBER_HEADER' , 'Internal Packet Number' , 1,  sysdate()  , 1 , 'Internal Packet Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'DOCKET_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'DOCKET_NUMBER_HEADER' , 'Docket Number' , 1,  sysdate()  , 1 , 'Docket Number' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SENT_DATE_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SENT_DATE_HEADER' , 'Sent Date' , 1,  sysdate()  , 1 , 'Sent Date' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Outward Item') );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ITEM_INSURED_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ITEM_INSURED_HEADER' , 'Item Insured' , 1,  sysdate()  , 1 , 'Item Insured' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'INSURED_BY_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'INSURED_BY_HEADER' , 'Insured By' , 1,  sysdate()  , 1 , 'Insured By' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'POLICY_NUMBER_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'POLICY_NUMBER_HEADER' , 'Policy Number ' , 1,  sysdate()  , 1 , 'Policy Number ' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'INSURANCE_AMOUNT_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'INSURANCE_AMOUNT_HEADER' , 'Insurance Amount' , 1,  sysdate()  , 1 , 'Insurance Amount' , 1, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'REMARK_HEADER'  and importUtilityMasterId=@importMasterId2 and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'REMARK_HEADER' , 'Remark' , 1,  sysdate()  , 1 , 'Remark' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Outward Item'));
END IF;

END $$
CALL V20210607102611__Insert_ConfigLoaderFDManagement() $$
DROP PROCEDURE IF EXISTS V20210607102611__Insert_ConfigLoaderFDManagement $$
DELIMITER ;