DELIMITER $$
DROP PROCEDURE IF EXISTS V20210803121112__Insert_EmployeeIdCardForSNJB $$
CREATE PROCEDURE V20210803121112__Insert_EmployeeIdCardForSNJB()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'SNJB_Employee_ID_Card')) THEN 
 INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
 VALUES ('13', 'SNJB_Employee_ID_Card', 'SNJB Employee ID Card', 'SNJB_Employee_ID_Card.png', 'CommonReport_IdCard_Horizontally.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'SNJB_Employee_ID_Card.jasper', 'AcademiaLogo.png');

END IF; 


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='SNJB_Employee_ID_Card'))) THEN
   
	set @employeeIDCard = (select id from report_template where templateCode ='SNJB_Employee_ID_Card');
	 
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@employeeIDCard, 'TRANS_DESIGNATION', 'Designation', '1', NOW()),
    (@employeeIDCard, 'TRANS_DEPARTMENT', 'Department', '1', NOW()),
    (@employeeIDCard, 'TRANS_DATE_OF_BIRTH', 'Date of Birth', '1', NOW()),
    (@employeeIDCard, 'TRANS_BLOOD_GROUP', 'Blood Group', '1', NOW()),
    (@employeeIDCard, 'TRANS_CONTACT_NO', 'Contact No.', '1', NOW()),
    (@employeeIDCard, 'TRANS_EMERGENCY_NO', 'Emergency No.', '1', NOW()),
	 (@employeeIDCard, 'TRANS_EMAIL_ID', 'Email ID', '1', NOW()),
    (@employeeIDCard, 'TRANS_ADDRESS', 'Address', '1', NOW());

  END IF;

END $$
CALL V20210803121112__Insert_EmployeeIdCardForSNJB() $$
DROP PROCEDURE IF EXISTS V20210803121112__Insert_EmployeeIdCardForSNJB $$
DELIMITER ;