DELIMITER $$
DROP PROCEDURE IF EXISTS V20210804123235__Insert_KRMUStudentIdCardReportTemp $$
CREATE PROCEDURE V20210804123235__Insert_KRMUStudentIdCardReportTemp()
BEGIN

IF NOT EXISTS ((select * from report_template where templateCode = 'KRMU_STUDENT_ID_CARD')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('7', 'KRMU_STUDENT_ID_CARD', 'KRMU Student ID Card', 'KRMU_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Horizontal_ATMCardSize.jasper', NULL, 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'KRMU_STUDENT_ID_CARD.jasper', 'AcademiaLogo.png');

set @KRMU_StudentIDCardTempId = (select max(id) from report_template where templateCode ='KRMU_STUDENT_ID_CARD');

IF EXISTS ((SELECT * FROM `report_template` WHERE `templateCode`='KRMU_STUDENT_ID_CARD')) THEN 
set @translationId = (SELECT `id` FROM `report_template` WHERE `templateCode`='KRMU_STUDENT_ID_CARD');
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@translationId, 'TRANS_STUDENT_ID_CARD', 'STUDENT ID CARD', NULL, NOW()),
(@translationId, 'TRANS_COURSE', 'Course', NULL, NOW()),
(@translationId, 'TRANS_BLOOD_GROUP', 'Blood Grp.', NULL, NOW()),
(@translationId, 'TRANS_MOBILE_NO', 'Mobile No.', NULL, NOW()),
(@translationId, 'TRANS_VALID_UPTO', 'Valid Upto', NULL, NOW()),
(@translationId, 'TRANS_INSTRUCTIONS', 'Instructions', NULL, NOW()),
(@translationId, 'TRANS_INSTRUCTION_ONE', 'First Instruction', NULL, NOW()),
(@translationId, 'TRANS_INSTRUCTION_TWO', 'Second Instruction', NULL, NOW()),
(@translationId, 'TRANS_INSTRUCTION_THREE', 'Third Instruction', NULL, NOW()),
(@translationId, 'TRANS_INSTRUCTION_FOUR', 'Fourth Instruction', NULL, NOW()),
(@translationId, 'TRANS_UNIVERSITY_NAME', 'University Name', NULL, NOW()),
(@translationId, 'TRANS_ADDRESS', 'Address', NULL, NOW()),
(@translationId, 'TRANS_EMAIL', 'Email', NULL, NOW()),
(@translationId, 'TRANS_WEBSITE', 'Website', NULL, NOW()),
(@translationId, 'TRANS_PHONE_NO', 'Ph. No.', NULL, NOW()),
(@translationId, 'TRANS_EMAIL_ID', 'Email ID', NULL, NOW()),
(@translationId, 'TRANS_WEBSITE_NAME', 'Website Name', NULL, NOW()),
(@translationId, 'TRANS_PHONE_NO_VALUE', 'Phone Number', NULL, NOW()),
(@translationId, 'TRANS_REGISTRAR_SIGNATURE', 'Registrar Signature', NULL, NOW());

END IF; 
END IF; 
END $$
CALL V20210804123235__Insert_KRMUStudentIdCardReportTemp() $$
DROP PROCEDURE IF EXISTS V20210804123235__Insert_KRMUStudentIdCardReportTemp $$
DELIMITER ;