DELIMITER $$
DROP PROCEDURE IF EXISTS V20210813191200__Create_studentRegistrationAcceptance $$
CREATE PROCEDURE V20210813191200__Create_studentRegistrationAcceptance()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='student_registration_acceptance')) THEN 
CREATE TABLE `student_registration_acceptance`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`studentId` BIGINT(20) NOT NULL,
	`periodId` BIGINT(20) NOT NULL,
    `registrationTermSetupDetailId` BIGINT(20) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	CONSTRAINT `fk_student_reg_1` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`),
	CONSTRAINT `fk_student_reg_2` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config`(`id`),
    CONSTRAINT `fk_student_reg_3` FOREIGN KEY (`registrationTermSetupDetailId`) REFERENCES `registration_term_setup_detail`(`id`),
	CONSTRAINT `fk_student_reg_4` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);
END IF; 

END $$
CALL V20210813191200__Create_studentRegistrationAcceptance () $$ 
DROP PROCEDURE IF EXISTS V20210813191200__Create_studentRegistrationAcceptance $$ 
DELIMITER ;