DELIMITER $$
DROP PROCEDURE IF EXISTS V20211208124331__Create_CatalogueContentCSM $$
CREATE PROCEDURE V20211208124331__Create_CatalogueContentCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='catalogue_content')) THEN 
CREATE TABLE catalogue_content (
    id BIGINT(20) NOT NULL AUTO_INCREMENT, 
    itemCode VARCHAR(255) NOT NULL,
    itemValue VARCHAR(255) NOT NULL,
    itemValueInOtherLanguage VARCHAR(255) NULL,
    sequenceNumber BIGINT(20) NULL,
    lastUpdatedBy BIGINT(20)NOT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id)
    );
  
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'catalogue_content','CATALOGUE_CONTENT','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'itemValueInOtherLanguage', 'ITEM_VALUE_IN_OTHER_LANGUAGE', @standardMasterMaxId+1, 'varchar', '3', 0, 0, 0, 1, '1', SYSDATE());
 
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'sequenceNumber', 'SEQUENCE_NUMBER', @standardMasterMaxId+1, 'Number', '4', 0, 0, 0, 1, 10, '1', SYSDATE());
 
END IF; 

END $$
CALL V20211208124331__Create_CatalogueContentCSM () $$ 
DROP PROCEDURE IF EXISTS V20211208124331__Create_CatalogueContentCSM $$ 
DELIMITER ;