DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_programmeenrolmentdetails //
CREATE DEFINER=`ss_root`@`%` PROCEDURE `sp_tvet_programmeenrolmentdetails`(in p_alid varchar(1000), in intakeYearId BIGINT)
BEGIN

select distinct 
case when char_length(per.nationalId)=13 then per.nationalID else null end as National_Id,
if ((char_length(per.nationalId)>0 && char_length(per.nationalId)<>13),per.nationalID ,usr.code) as Person_Alternate_Id,
if ((char_length(per.nationalId)>0 && char_length(per.nationalId)<>13),527,537) as Alternate_Id_Type_Id,
case when aaw.itemCode='1' then prog.programRegistrationId else null end as Qualification_Id,
case when progbs.exitDate is not null then 10 else 3 end as Enrolment_Status_Id,
'' as Filler01,
case when modo.itemCode is null then 4 else modo.itemCode end as Enrolment_Type_Id,
case when progbs.exitDate is not null then DATE_FORMAT(progbs.exitDate, '%Y%m%d') else DATE_FORMAT(progbs.entryDate, '%Y%m%d') end Enrolment_Status_Date,
DATE_FORMAT(progbs.entryDate, '%Y%m%d') as Enrolment_Date,
'' as Filler02,
aaw.itemCode as Part_Of_Id,
case when aaw.itemCode='3' then prog.programRegistrationId else null end Learnership_Id,
loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id,
'' as Filler03,
case when aaw.itemCode='1' and prog.programRegistrationId is not null then null else prog.programCode end as Programme_Code,
case when progbs.exitDate is not null then 16 else '' end as Enrolment_Status_Reason_Id,
DATE_FORMAT(progbs.entryDate, '%Y%m%d') as Most_Recent_Registration_Date,
'' as Certificate_Number,
0.00 as Instutional_Housing_FTEInstutional_Housing_FTE,
case when per.nationalID is not null and char_length(per.nationalId)=13 then 3 else 1 end as Entrance_Category_Id,
case when per.nationalID is not null and char_length(per.nationalId)=13 then null
when (char_length(per.nationalId) <> 13 OR per.nationalID is null) and dom.id is null then 99 else dom.id end as Previous_Activity_Id,
case when btc.batchPartTime = 1 then 2 else 1 end as Enrolment_Mode_Id,
case when stus.itemCode = 6 then 1 when stus.itemCode = 7 then 2 else 4 end as Economic_Status_Id,
case when au.itemCode is null then 1 else au.itemCode end as Partnership_Id,
'' as SDL_No, -- CF1 from Training Details of Student
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
 from
program_batch_students progbs
join batches btc  on(progbs.programBatchId=btc.id and btc.startDate < NOW() and btc.intakeYearId=intakeYearId)
join programs prog on(prog.id=btc.programId)
join admission adm on (progbs.admissionId=adm.id and adm.activeStatus = 1)
join students stu on(stu.userId=adm.studentId)
left join users usr on(usr.id=stu.userid)
join persons per on(per.id=stu.personId)
left join mode_of_delivery modo on(btc.modeOfDeliveryId=modo.id)
left join academic_award aaw on(aaw.id=prog.academicAwardId)
join academy_location al on(al.id=prog.academyLocationId)
join locations loc on(loc.id=al.locationId)
left join registration_type rt on(prog.registrationTypeId=rt.id)
left join  domicile dom on(dom.id=per.domicileId)
left join  student_status stus on(stus.id=per.studentStatusId)
left join affiliated_university au on(au.id=prog.affiliatedUniversityId)
left join
(select iddtla.idNumber,iddtla.personId,iddtla.itemCode from(
select idNumber,personId,idt.itemCode,row_number() OVER (PARTITION BY personId ORDER BY isnull(validTillDate) desc,validTillDate desc) rn
from identity_detail iddet join identity_type idt on(iddet.idType=idt.id and idt.itemCode='Passport')) iddtla where iddtla.rn=1)
iddetail on(iddetail.personId=per.id)
where 
usr.status=1 and adm.activeStatus=1 
and progbs.exitdate is null
and year(now()) between year(btc.startDate) and year(btc.tillDate) and  FIND_IN_SET( al.id,p_alid)
group by prog.id,usr.id;

END//
DELIMITER ;