DELIMITER $$
DROP PROCEDURE IF EXISTS V20220808143812__Create_PostDocInfoTable $$
CREATE PROCEDURE V20220808143812__Create_PostDocInfoTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='post_doc_info')) THEN 
CREATE TABLE `post_doc_info`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `personId` BIGINT(20) NOT NULL,
  `contractStartDate` Date NULL,
  `contractEndDate` Date NULL,
  `qualificationName` VARCHAR(255) NULL,
  `qualificationInstitution` VARCHAR(255) NULL,
  `obtainedDoctorateFieldOfStudyId` BIGINT(20) NULL,
  `doctorateObtainedDate` Date NULL,
  `postDocFieldOfStudyId` BIGINT(20) NULL,
  `departmentId` BIGINT(20) NULL,
  `financialResourceOneId` BIGINT(20) NULL,
  `financialResourceTwoId` BIGINT(20) NULL,
  `financialResourceThreeId` BIGINT(20) NULL,
  `financialResourceFourId` BIGINT(20) NULL,
  `auditDate` Date NULL,
  `auditId` BIGINT(20) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `post_doc_info_personId_FK` FOREIGN KEY (`personId`) REFERENCES `persons`(`id`),
  CONSTRAINT `post_doc_info_obtainedDoctorateFieldOfStudyId_FK` FOREIGN KEY (`obtainedDoctorateFieldOfStudyId`) REFERENCES `program_cesm`(`id`),
  CONSTRAINT `post_doc_info_postDocFieldOfStudyId_FK` FOREIGN KEY (`postDocFieldOfStudyId`) REFERENCES `program_cesm`(`id`),
  CONSTRAINT `post_doc_info_department_FK` FOREIGN KEY (`departmentId`) REFERENCES `department`(`id`),
  CONSTRAINT `post_doc_info_financialResourceOneId_FK` FOREIGN KEY (`financialResourceOneId`) REFERENCES `financial_resource`(`id`),
  CONSTRAINT `post_doc_info_financialResourceTwoId_FK` FOREIGN KEY (`financialResourceTwoId`) REFERENCES `financial_resource`(`id`),
  CONSTRAINT `post_doc_info_financialResourceThreeId_FK` FOREIGN KEY (`financialResourceThreeId`) REFERENCES `financial_resource`(`id`),
  CONSTRAINT `post_doc_info_financialResourceFourId_FK` FOREIGN KEY (`financialResourceFourId`) REFERENCES `financial_resource`(`id`),
  CONSTRAINT `post_doc_info_auditId_FK` FOREIGN KEY (`auditId`) REFERENCES `users`(`id`),
  CONSTRAINT `post_doc_info_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) 
ENGINE=INNODB DEFAULT  CHARSET=utf8;
END IF; 

END $$
CALL V20220808143812__Create_PostDocInfoTable () $$ 
DROP PROCEDURE IF EXISTS V20220808143812__Create_PostDocInfoTable $$ 
DELIMITER ;