DELIMITER $$
DROP PROCEDURE IF EXISTS V20221005145216__Create_StudentEthicsClearanceLetterTable $$
CREATE PROCEDURE V20221005145216__Create_StudentEthicsClearanceLetterTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_ethics_clearance_letter')) THEN 
CREATE TABLE `student_ethics_clearance_letter`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint NOT NULL,
`approvalDate` date NOT NULL,
`approvalPeriodStartDate` date NOT NULL,
`approvalPeriodEndDate` date NOT NULL,
`coInvestigatorName` BIGINT(20) DEFAULT NULL,
`projectNumberID` VARCHAR(255) NOT NULL,
`auditDate` date DEFAULT NULL,
`auditId` bigint NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_studentEthicsClearanceLetter_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_studentEthicsClearanceLetter_SU_coInvestigatorName` FOREIGN KEY (`coInvestigatorName`) REFERENCES `users` (`id`),
CONSTRAINT `FK_studentEthicsClearanceLetter_SU_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_studentEthicsClearanceLetter_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
 ) ;
END IF; 

END $$
CALL V20221005145216__Create_StudentEthicsClearanceLetterTable () $$ 
DROP PROCEDURE IF EXISTS V20221005145216__Create_StudentEthicsClearanceLetterTable $$ 
DELIMITER ;