DELIMITER $$
DROP PROCEDURE IF EXISTS V20221114125133__Update_AttendanceCourseWiseDL $$
CREATE PROCEDURE V20221114125133__Update_AttendanceCourseWiseDL()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='schedule_event_trigger_details' AND column_name= 'displayCode')) THEN 
 ALTER TABLE `schedule_event_trigger_details`
  ADD `displayCode` varchar(100); 
END IF; 

IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='MSG_COURSEWISE_WEEKLY_ATTENDANCE_DL')) THEN 
SET @dtproviderSudentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_COURSEWISE_WEEKLY_ATTENDANCE_DL');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT  T5.studentId AS USER_ID
 FROM
     student_course_attendance T1
         LEFT JOIN
     student_course_attendance_details T2 ON T2.attendanceId = T1.id
         LEFT JOIN
     admission T5 ON T5.id = T2.admissionId  
  where T5.academyLocationId  = (SELECT  academyLocation FROM  schedule_event_trigger_details where status='Start'  and triggeredOn =(SELECT max(triggeredOn)  FROM  schedule_event_trigger_details )  LIMIT 1)
 GROUP BY T2.admissionId " WHERE `dataProviderId`=@dtproviderSudentId;
END IF; 

IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='MSG_COURSEWISE_WEEKLY_ATTENDANCE_PARENT_DL')) THEN 
SET @dtproviderSudentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_COURSEWISE_WEEKLY_ATTENDANCE_PARENT_DL');
UPDATE `sql_dtprovider` SET `sqlQuery`="select 
     T9.id AS USER_ID    
 FROM
     program_batch_students T1
         LEFT JOIN    
     admission T5 ON T5.id = T1.admissionId
     left join 
     students T6 on T6.userId = T5.studentId
      left join 
     persons T7 on T7.id = T6.personId
      left join 
     person_relationships T8 on T8.personId = T7.id
     inner join 
     persons T9 on T9.id = T8.relatedPersonId
  where  T8.whetherDeleted = false AND  T5.academyLocationId  = (SELECT  academyLocation FROM  schedule_event_trigger_details where status='Start' and triggeredOn =(SELECT max(triggeredOn)  FROM  schedule_event_trigger_details )  LIMIT 1)
 GROUP BY T9.id " WHERE `dataProviderId`=@dtproviderSudentId;
 END IF;
 
 IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='DAILY_ATTENDANCE_MISSED_BY_FACULTY_DL')) THEN 
 SET @dtproviderSudentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_ATTENDANCE_MISSED_BY_FACULTY_DL');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS USER_ID
FROM
    course_coverage_plan T1
WHERE
    T1.studentCourseAttendanceId IS NULL
        AND T1.sessionDate = DATE(NOW() - INTERVAL 1 DAY)
        AND T1.academyLocationId in (namedParams)" WHERE `dataProviderId`=@dtproviderSudentId;
 END IF;

  IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='CONSOLIDATE_ATTENDANCE_MISSED_BY_FACULTY_DL')) THEN 
 
SET @dtproviderSudentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CONSOLIDATE_ATTENDANCE_MISSED_BY_FACULTY_DL');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.facultyId AS USER_ID
FROM
    course_coverage_plan T1
        LEFT JOIN
     program_batch_course_param prm on prm.courseVarientId = T1.courseVariantId
        LEFT JOIN
    prog_batch_period_config T2 ON T2.id = prm.progBatchPeriodConfigId        
WHERE
    T1.studentCourseAttendanceId IS NULL
         AND T1.academyLocationId in (namedParams)
        AND T1.sessionDate <= DATE(NOW())
        AND T2.isCurrentPeriodOfProgram = TRUE
        AND T1.whetherDeleted = false
GROUP BY T1.facultyId " WHERE `dataProviderId`=@dtproviderSudentId;
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20221114125133__Update_AttendanceCourseWiseDL () $$
DROP PROCEDURE IF EXISTS V20221114125133__Update_AttendanceCourseWiseDL $$
DELIMITER ;