DELIMITER $$
DROP PROCEDURE IF EXISTS V20221118160514__Create_exchangeSemesterServiceRequest $$
CREATE PROCEDURE V20221118160514__Create_exchangeSemesterServiceRequest()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exchange_xsemester_request_details')) THEN 
CREATE TABLE `exchange_xsemester_request_details` (
 `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
 `serviceRequestId` BIGINT(20) NOT NULL, 
 `fromProgramId` BIGINT(20) NOT NULL,
 `toProgramId` BIGINT(20) NOT NULL,
 `fromAcademyLocationId` BIGINT(20) NOT NULL,
 `toAcademyLocationId` BIGINT(20) NOT NULL,
 `toCampusId` BIGINT(20) NOT NULL,
 `toBatchId` BIGINT(20) NOT NULL,
 `toPeriodId` BIGINT(20) NOT NULL,
 `toSeatTypeId` BIGINT(20) NOT NULL,
 `version` BIGINT NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
 `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
 PRIMARY KEY (`id`),
 INDEX `fk_serviceRequestId_Id_idx`(`serviceRequestId` ASC),
 INDEX `fk_fromProgram_Id_idx` (`fromProgramId` ASC),
 INDEX `fk_toProgram_Id_idx` (`toProgramId` ASC),
 INDEX `fk_fromAcademyLocation_Id_idx` (`fromAcademyLocationId` ASC),
 INDEX `fk_toAcademyLocation_Id_idx` (`toAcademyLocationId` ASC),
 INDEX `fk_toCampus_Id_idx` (`toCampusId` ASC),
 INDEX `fk_toBatch_Id_idx` (`toBatchId` ASC),
 INDEX `fk_toPeriod_Id_idx` (`toPeriodId` ASC),
 INDEX `fk_toSeatType_Id_idx` (`toSeatTypeId` ASC),
 INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
 CONSTRAINT `fk_exchg_sem_serviceRequestId`
 FOREIGN KEY (`serviceRequestId`)
 REFERENCES `service_requests` (`id`),
 CONSTRAINT `fk_exchg_sem_fromProgramId`
 FOREIGN KEY (`fromProgramId`)
 REFERENCES `programs` (`id`),
 CONSTRAINT `fk_exchg_sem_toProgramId`
 FOREIGN KEY (`toProgramId`)
 REFERENCES `programs` (`id`),
 CONSTRAINT `fk_exchg_sem_fromAcademyLocationId`
 FOREIGN KEY (`fromAcademyLocationId`)
 REFERENCES `academy_location` (`id`), 
 CONSTRAINT `fk_exchg_sem_toAcademyLocationId`
 FOREIGN KEY (`toAcademyLocationId`)
 REFERENCES `academy_location` (`id`), 
 CONSTRAINT `fk_exchg_sem_toCampusId`
 FOREIGN KEY (`toCampusId`)
 REFERENCES `academy_location_campus` (`id`), 
 CONSTRAINT `fk_exchg_sem_toBatchId`
 FOREIGN KEY (`toBatchId`)
 REFERENCES `batches` (`id`), 
 CONSTRAINT `fk_exchg_sem_toPeriodId`
 FOREIGN KEY (`toPeriodId`)
 REFERENCES `prog_batch_period_config` (`id`), 
 CONSTRAINT `fk_exchg_sem_toSeatTypeId`
 FOREIGN KEY (`toSeatTypeId`)
 REFERENCES `seat_types` (`id`), 
 CONSTRAINT `fk_exchg_sem_lastUpdated` 
 FOREIGN KEY (`lastUpdatedBy`) 
 REFERENCES `users` (`id`)
 ON DELETE RESTRICT
 ON UPDATE RESTRICT);
END IF;
 
END $$
CALL V20221118160514__Create_exchangeSemesterServiceRequest () $$ 
DROP PROCEDURE IF EXISTS V20221118160514__Create_exchangeSemesterServiceRequest $$ 
DELIMITER ;