DELIMITER $$
DROP PROCEDURE IF EXISTS V20230106110709__Create_directStudentTransferTable $$
CREATE PROCEDURE V20230106110709__Create_directStudentTransferTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='direct_student_transfer')) THEN 
CREATE TABLE direct_student_transfer(
 id BIGINT NOT NULL AUTO_INCREMENT,
 admissionId BIGINT NOT NULL,
 fromAcademyLocationId BIGINT NOT NULL,
 fromProgramId BIGINT NOT NULL,
 fromBatchId BIGINT NOT NULL,
 fromProgramBatchSeatConfigurationId BIGINT NOT NULL,
 toAcademyLocationId BIGINT NOT NULL,
 toProgramId BIGINT NOT NULL,
 toBatchId BIGINT NOT NULL,
 toProgramBatchSeatConfigurationId BIGINT NOT NULL,
 transferDate  DATE DEFAULT NULL,
 inactiveReasonCode VARCHAR(255) NOT NULL,
 lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
 lastUpdatedBy BIGINT DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_direct_transfer_fromAcademyLocationId` FOREIGN KEY (`fromAcademyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_direct_transfer_toAcademyLocationId` FOREIGN KEY (`toAcademyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_direct_transfer_admissionId` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `fk_direct_transfer_fromProgramId` FOREIGN KEY (`fromProgramId`) REFERENCES `programs` (`id`),
  CONSTRAINT `fk_direct_transfer_toProgramId` FOREIGN KEY (`toProgramId`) REFERENCES `programs` (`id`),
  CONSTRAINT `fk_direct_transfer_fromBatchId` FOREIGN KEY (`fromBatchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `fk_direct_transfer_toBatchId` FOREIGN KEY (`toBatchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `fk_direct_transfer_fromProgramBatchSeatConfigurationId` FOREIGN KEY (`fromProgramBatchSeatConfigurationId`) REFERENCES `prog_batch_seat_config` (`id`),
  CONSTRAINT `fk_direct_transfer_toProgramBatchSeatConfigurationId` FOREIGN KEY (`toProgramBatchSeatConfigurationId`) REFERENCES `prog_batch_seat_config` (`id`)
);
END IF; 

END $$
CALL V20230106110709__Create_directStudentTransferTable () $$ 
DROP PROCEDURE IF EXISTS V20230106110709__Create_directStudentTransferTable $$ 
DELIMITER ;