DELIMITER $$
DROP PROCEDURE IF EXISTS V20230501174134__Insert_PostgraduateNonResidentialDFR $$
CREATE PROCEDURE V20230501174134__Insert_PostgraduateNonResidentialDFR()
BEGIN

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'personalinformationform' and  formFieldName ='postgraduateNonResidentialStudent' and formFieldId = 'postgraduateNonResidentialStudentId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('personalinformationform','postgraduateNonResidentialStudent','postgraduateNonResidentialStudentId','radiogroup',0,0,NULL,1, NOW() ,'Postgraduate: Non-Residential Student','1','Personal Details Info','Create, Edit, and View','Postgraduate: Non-Residential Student',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicantSignUpPageSU' and  formFieldName ='postgraduateNonResidentialStudent' and formFieldId = 'postgraduateNonResidentialStudentId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('applicantSignUpPageSU','postgraduateNonResidentialStudent','postgraduateNonResidentialStudentId','radiogroup',0,0,NULL,1, NOW() ,'Postgraduate: Non-Residential Student','null','Applicant Sign Up Page','Create, Edit, and View','Postgraduate: Non-Residential Student',0);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'DIPLOMATIC_STATUS' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','DIPLOMATIC_STATUS',"Diplomatic Status","Diplomatic Status","Diplomatieke Status","Tình trạng ngoại giao",now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'WORK_CRITICAL_SKILLS_VISA' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','WORK_CRITICAL_SKILLS_VISA',"Work Critical Skills Visa","Work Critical Skills Visa","Werk Kritiese Vaardighede Visa","Visa kỹ năng quan trọng làm việc",now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'TEMPORARY_STUDY_VISA' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','TEMPORARY_STUDY_VISA',"Temporary Study Visa","Temporary Study Visa","Tydelike studievisum","Visa du học tạm thời",now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'POSTGRADUATE_NON-RESIDENTIAL_STUDENT' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','POSTGRADUATE_NON-RESIDENTIAL_STUDENT',"Postgraduate: Non-Residential Student","Postgraduate: Non-Residential Student","Nagraads: Nie-residensiële student","Sau đại học: Sinh viên không cư trú",now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'POSTGRADUATE_NON-RESIDENTIAL_STUDENT' and  objectName ='PORTAL_SETUP_NEW')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('PORTAL_SETUP_NEW','POSTGRADUATE_NON-RESIDENTIAL_STUDENT',"Postgraduate: Non-Residential Student","Postgraduate: Non-Residential Student","Nagraads: Nie-residensiële student","Sau đại học: Sinh viên không cư trú",now(),1);
END IF;

END $$
CALL V20230501174134__Insert_PostgraduateNonResidentialDFR() $$
DROP PROCEDURE IF EXISTS V20230501174134__Insert_PostgraduateNonResidentialDFR $$
DELIMITER ;