DELIMITER $$
DROP PROCEDURE IF EXISTS V20230613140254__Create_business_rule_scholarship_mapping $$
CREATE PROCEDURE V20230613140254__Create_business_rule_scholarship_mapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='business_rule_scholarship_mapping')) THEN 
CREATE TABLE `business_rule_scholarship_mapping` (
`id` BIGINT NOT NULL AUTO_INCREMENT,
  `businessRuleId` BIGINT NOT NULL,
  `scholarshipId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT now(),
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_bisunnes_rule_idx_idx` (`businessRuleId` ASC) ,
  INDEX `fk_scholarship_idx_idx` (`scholarshipId` ASC) ,
 CONSTRAINT `businessRuleId`
    FOREIGN KEY (`businessRuleId`)
    REFERENCES `business_rule` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `scholarshipId`
    FOREIGN KEY (`scholarshipId`)
    REFERENCES `scholarship` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_business_rule_scholarship_mapping_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
    );
END IF; 

END $$
CALL V20230613140254__Create_business_rule_scholarship_mapping () $$ 
DROP PROCEDURE IF EXISTS V20230613140254__Create_business_rule_scholarship_mapping $$ 
DELIMITER ;