DELIMITER $$
DROP PROCEDURE IF EXISTS V20230731172339__Create_StudentServiceAttendanceDtlsTable $$
CREATE PROCEDURE V20230731172339__Create_StudentServiceAttendanceDtlsTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_service_attendance_details')) THEN 
CREATE TABLE `student_service_attendance_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attendanceId` bigint(20) NOT NULL,
  `admissionId` bigint(20) NOT NULL,
  `attendanceStatus` varchar(25) NOT NULL,
  `attendanceMarkingTypeId` bigint NOT NULL,
  `attendanceComment` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refusers1464_42` (`lastUpdatedBy`),
  KEY `Refstudent_service_attendance1837_42` (`attendanceId`),
  KEY `Ref_admission_idx_42` (`admissionId`),
  KEY `fk_student_service_attendance_details_1_idx` (`attendanceMarkingTypeId`),
  CONSTRAINT `fk_student_service_attendance_details_1` FOREIGN KEY (`attendanceMarkingTypeId`) REFERENCES `attendance_marking_type` (`id`),
  CONSTRAINT `Refstudent_service_attendance1837_42` FOREIGN KEY (`attendanceId`) REFERENCES `student_service_attendance` (`id`),
  CONSTRAINT `Refusers1464_42` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `Ref_admission_42` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
); 
END IF; 

END $$
CALL V20230731172339__Create_StudentServiceAttendanceDtlsTable () $$ 
DROP PROCEDURE IF EXISTS V20230731172339__Create_StudentServiceAttendanceDtlsTable $$ 
DELIMITER ;