DELIMITER $$
DROP PROCEDURE IF EXISTS V20230803101117__Insert_ApplicantInsuranceDataGrid $$
CREATE PROCEDURE V20230803101117__Insert_ApplicantInsuranceDataGrid()
BEGIN

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.personinfo.common.personalinfo.ApplicantInsuranceDetailsGrid'  and portalId=1)) THEN 
INSERT INTO `data_grid`
(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('Academia.view.personinfo.common.personalinfo.ApplicantInsuranceDetailsGrid',1,
'[{"id":null,"columnName":"HEALTH_INSURANCE_CONFIRMED","dataIndex":"healthInsuranceConfirmed","columnVisibility":"SHOW","sequence":1,"mandatory":true},
  {"id":null,"columnName":"SCHOOL_INSURANCE_TYPE","dataIndex":"schoolInsuranceTypeValue","columnVisibility":"SHOW","sequence":2,"mandatory":false},
  {"id":null,"columnName":"HEALTH_INSURANCE_DOCUMENT","dataIndex":"applicantInsuranceDocuments","columnVisibility":"SHOW","sequence":3,"mandatory":false},
  {"id":null,"columnName":"HEALTH_INSURANCE_DOCUMENT_URL","dataIndex":"applicantInsuranceDocumentUrls","columnVisibility":"SHOW","sequence":4,"mandatory":false}]'
  ,now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'STUDENT_INSURANCE' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','STUDENT_INSURANCE',"Student Insurance","Student Insurance","Studenteversekering","Bảo hiểm sinh viên",now(),1);
END IF;	

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'APPLICANT_INSURANCE' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','APPLICANT_INSURANCE',"Applicant Insurance","Applicant Insurance","Aansoeker Versekering","Bảo hiểm người nộp đơn",now(),1);
END IF;	

END $$
CALL V20230803101117__Insert_ApplicantInsuranceDataGrid() $$
DROP PROCEDURE IF EXISTS V20230803101117__Insert_ApplicantInsuranceDataGrid $$
DELIMITER ;