DELIMITER $$
DROP PROCEDURE IF EXISTS V20230809142314__Insert_TranslationScholarshipRequest $$
CREATE PROCEDURE V20230809142314__Insert_TranslationScholarshipRequest()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' AND keyName='REQUEST_APPROVED_SUCCESSFULLY')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('TRANSLATIONS', 'REQUEST_APPROVED_SUCCESSFULLY', 'Scholarship request has been approved successfully.', 'Scholarship request has been approved successfully.', 'Beursversoek is suksesvol goedgekeur.', 'Yêu cầu học bổng đã được phê duyệt thành công.',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' AND keyName='REQUEST_REJECTED_SUCCESSFULLY')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('TRANSLATIONS', 'REQUEST_REJECTED_SUCCESSFULLY', 'Scholarship request has been rejected.', 'Scholarship request has been rejected.', 'Beursversoek is afgekeur.', 'Yêu cầu học bổng đã bị từ chối.',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' AND keyName='REQUEST_SUBMITTED_SUCCESSFULLY')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('TRANSLATIONS', 'REQUEST_SUBMITTED_SUCCESSFULLY', 'Scholarship request has been re-submitted successfully.', 'Scholarship request has been re-submitted successfully.', 'Beursversoek is weer suksesvol ingedien.', 'Yêu cầu học bổng đã được gửi lại thành công.',now(),1);
END IF; 

END $$
CALL V20230809142314__Insert_TranslationScholarshipRequest() $$
DROP PROCEDURE IF EXISTS V20230809142314__Insert_TranslationScholarshipRequest $$
DELIMITER ;