DELIMITER $$
DROP PROCEDURE IF EXISTS V20230906163632__Create_CSM_StudentJourneyAddedStatus $$
CREATE PROCEDURE V20230906163632__Create_CSM_StudentJourneyAddedStatus()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_journey_added_status')) THEN 
CREATE TABLE `student_journey_added_status` (
`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
`itemCode` VARCHAR(100) NOT NULL,
`itemValue` VARCHAR(100) NOT NULL,
`visibility` BIT(1) DEFAULT 0,
`sequence` BIGINT(20) DEFAULT 0,
`lastUpdatedBy` BIGINT(20) NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
PRIMARY KEY (`id`),
UNIQUE KEY itemCode_UNIQUE (itemCode),
    KEY fk_student_journey_added_status_lastUpdatedBy_idx (lastUpdatedBy),
    CONSTRAINT fk_student_journey_added_status_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'student_journey_added_status')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`)
VALUES (@standardMasterMaxId+1, NULL,'student_journey_added_status','STUDENT_JOURNEY_ADDED_STATUS','Student Profile','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;


IF  EXISTS ((select * from standard_master where tableName = 'student_journey_added_status')) THEN
SET @standardMasterId=(select id from standard_master where tableName = 'student_journey_added_status');
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='ITEM_CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='ITEM_VALUE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='VISIBILITY')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('visibility','VISIBILITY',@standardMasterId,'boolean',NULL,3,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='SEQUENCE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('sequence','SEQUENCE',@standardMasterId,'Number',NULL,4,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF;
END IF;

-- ------------------TRANSLATION-------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'STUDENT_JOURNEY_ADDED_STATUS')) THEN
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'STUDENT_JOURNEY_ADDED_STATUS', 'Student Journey Added Status', 'Student Journey Added Status',null,null,now(),1);
END IF;

END $$
CALL V20230906163632__Create_CSM_StudentJourneyAddedStatus () $$ 
DROP PROCEDURE IF EXISTS V20230906163632__Create_CSM_StudentJourneyAddedStatus $$ 
DELIMITER ;