DELIMITER $$
DROP PROCEDURE IF EXISTS V20231004111524__Alter_StudentHostelApplication_Main $$
CREATE PROCEDURE V20231004111524__Alter_StudentHostelApplication_Main()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_hostel_application')) THEN 
drop table student_hostel_application;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_hostel_application')) THEN 
CREATE TABLE student_hostel_application (
id bigint NOT NULL AUTO_INCREMENT,
academyLocationId bigint Default NULL,
applicationStatus varchar(50) Default NULL,
hostelApplicationSetupId bigint Default NULL,
isReallocateSameHostel boolean default false,
studentId bigint Default NULL,
applicationDate date DEFAULT NULL,
allocatedDate date DEFAULT NULL,
allocatedById bigint default null,
cancelledById bigint default null,
cancellationReason varchar(255) default null,
allottedHostelRoomAllotmentId bigint Default NULL,
allocatedHostelId bigint Default NULL,
allocationYearId bigint Default NULL,
appliedForHostelId bigint Default NULL,
hostelApplicationType varchar(255) Default NULL,
setupCodeValue varchar(255) Default NULL,
hostelApplicationYearId bigint Default NULL,

lastUpdatedBy bigint NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (id),
CONSTRAINT FK_academyLocId_studentHostelApp FOREIGN KEY (academyLocationId) REFERENCES academy_location (id),
CONSTRAINT FK_hostelAppSetupId_studentHostelApp FOREIGN KEY (hostelApplicationSetupId) REFERENCES hostel_application_setup (id),
CONSTRAINT FK_studentId_studentHostelApp FOREIGN KEY (studentId) REFERENCES students (userId),
CONSTRAINT FK_allottedHostelRoomAllotmentId_studentHostelApp FOREIGN KEY (allottedHostelRoomAllotmentId) REFERENCES hostel_room_allotment (id),
CONSTRAINT FK_allocatedHostelId_studentHostelApp FOREIGN KEY (allocatedHostelId) REFERENCES resources (id),
CONSTRAINT FK_allocationYearId_studentHostelApp FOREIGN KEY (allocationYearId) REFERENCES academic_term (id),
CONSTRAINT FK_appliedForHostelId_studentHostelApp FOREIGN KEY (appliedForHostelId) REFERENCES resources (id),
CONSTRAINT FK_hostelAppYearId_studentHostelApp FOREIGN KEY (hostelApplicationYearId) REFERENCES academic_term (id),
CONSTRAINT fk_allocated_by_id_student_hostel foreign key(allocatedById) references users(id),
CONSTRAINT fk_cancelled_by_id_student_hostel foreign key(cancelledById) references users(id),
FOREIGN KEY (lastUpdatedBy) REFERENCES users (id));
END IF; 

END $$
CALL V20231004111524__Alter_StudentHostelApplication_Main() $$
DROP PROCEDURE IF EXISTS V20231004111524__Alter_StudentHostelApplication_Main $$
DELIMITER ;