DELIMITER $$
DROP PROCEDURE IF EXISTS V20231212132313__Create_zohoLead $$
CREATE PROCEDURE V20231212132313__Create_zohoLead()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='zoho_lead')) THEN 
CREATE TABLE zoho_lead (
    id bigint NOT NULL AUTO_INCREMENT,
    leadNo VARCHAR(255),
    leadRecordId VARCHAR(255),
    whenWouldLikeToStartStudy VARCHAR(255),
    leadName VARCHAR(255),
    firstName VARCHAR(255),
    middleName VARCHAR(255),
    lastName VARCHAR(255),
    interestedIn VARCHAR(255),
    dateOfBirth VARCHAR(255),
    gender VARCHAR(255),
    nationality VARCHAR(255),
    countryOfBirth VARCHAR(255),
    preferredCampusLocation VARCHAR(255),
    email VARCHAR(255),
    disability VARCHAR(255),
    ifOtherPleaseGiveDetails VARCHAR(255),
    houseFlatNumber VARCHAR(255),
    street VARCHAR(255),
    city VARCHAR(255),
    zipCode VARCHAR(255),
    countryOfResidence VARCHAR(255),
    mobile VARCHAR(255),
    emergencyContact VARCHAR(255),
    directApplicant BOOLEAN,
    leadSource VARCHAR(255),
    leadChannel VARCHAR(255),
    agencySName VARCHAR(255),
    owner VARCHAR(255),
    passportIDNumber VARCHAR(255),
    passportIDExpiryDate VARCHAR(255),
    emiratesID VARCHAR(255),
    uaeVisaRequired VARCHAR(255),
    typeOfApplication VARCHAR(255),
    transferredToUnit4 VARCHAR(255),
    unconditionalOfferSentDate VARCHAR(255),
    pleaseChooseAfterReadingInfo VARCHAR(255),
    entryRouteForHNCHNDApplicantsOnly VARCHAR(255),
    exempted VARCHAR(255),
    englishLanguageTest VARCHAR(255),
    date VARCHAR(255),
    overall1 VARCHAR(255),
    englishTestSubmitted bit(1) DEFAULT b'1',
    dateTime VARCHAR(255),
    englishProficiency VARCHAR(255),
    motivation VARCHAR(255),
    commentsByInterviewer VARCHAR(255),
    decisionByInterviewer VARCHAR(255),
    highestQualification VARCHAR(255),
    schoolCollegeUniversity VARCHAR(255),
    qualificationTitle VARCHAR(255),
    courseFinishDate VARCHAR(255),
    scoresAchieved VARCHAR(255),
    scoresAchieved1 VARCHAR(255),
    countryOfHighestQualification VARCHAR(255),
    salutation VARCHAR(255),
    countryCode VARCHAR(255),
    cellCountrycode VARCHAR(255),
	recordProcessed bit(1) DEFAULT false,
	errorLog VARCHAR(255),
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_zoho_lead_lastUpdatedBy_idx (lastUpdatedBy),
  CONSTRAINT fk_zoho_lead_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
) ENGINE=InnoDB;
END IF; 

END $$
CALL V20231212132313__Create_zohoLead () $$ 
DROP PROCEDURE IF EXISTS V20231212132313__Create_zohoLead $$ 
DELIMITER ;