DELIMITER $$
DROP PROCEDURE IF EXISTS V20240117170813__Insert_AdmissionInactiveReasonSeedData $$
CREATE PROCEDURE V20240117170813__Insert_AdmissionInactiveReasonSeedData()
BEGIN

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'PROVISIONAL_ADMISSION_CANCELLED')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('PROVISIONAL_ADMISSION_CANCELLED', 'Provisional Admission Cancellation', now(), '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'TRIAL_ADMISSION_CANCELLED')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('TRIAL_ADMISSION_CANCELLED', 'Trial Admission Cancellation', now(), '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'DEBARRED')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('TEMPORARY_TERMINATION', 'Debarred', now(), '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'PERMANENT_TERMINATION')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('PERMANENT_TERMINATION', 'Permanent Termination', now(), '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'COMPLETION_PASSED_OUT')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('COMPLETION_PASSED_OUT', 'Pass Out', now(), '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'WITHDRAWN_FROM_PROGRAM')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('WITHDRAWN_FROM_PROGRAM', 'Withdrawn From Program', now(), '1');
  END IF;
  

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'TRANSFER')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('TRANSFER', 'Transfer', now(), '1');
END IF;

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'PROGRAM_PROMOTION')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('PROGRAM_PROMOTION', 'Promoted', now(), '1');
END IF;

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'ACADEMY_LOCATION_TRANSFER')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('ACADEMY_LOCATION_TRANSFER', 'Academy Location Transfer', now(), '1');
END IF;

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'PROGRAM_PASSOUT')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('PROGRAM_PASSOUT', 'Program Passout', now(), '1');
END IF;

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'PROGRAM_TRANSFER')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('PROGRAM_TRANSFER', 'Program Transfer', now(), '1');
END IF;

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'BATCH_TRANSFER')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('BATCH_TRANSFER', 'Intake Transfer', now(), '1');
END IF;
	
    
    
IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'STUDENT_LEAVING')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('STUDENT_LEAVING', 'Student Leaving', now(), '1');
END IF;


IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'ADMISSION_CANCELLATION')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('ADMISSION_CANCELLATION', 'Admission Cancellation', now(), '1');
END IF;

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'STUDENT_TERMINATION')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('STUDENT_TERMINATION', 'Student Terminatior', now(), '1');
END IF;


IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'EXPIRE_BY_VALID_TILL')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('EXPIRE_BY_VALID_TILL', 'Valid Till date functionality', now(), '1');
END IF;


IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'LEAVE_OF_ABSENCE')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('LEAVE_OF_ABSENCE', '"Leave Of Absence', now(), '1');
END IF;

IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'SUSPENSION')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('SUSPENSION', 'Suspension', now(), '1');
END IF;
	
 IF NOT EXISTS ((SELECT * FROM `admission_inactive_reason` WHERE itemCode = 'EXCHANGE_SEMESTER')) THEN 
INSERT INTO `admission_inactive_reason` (`itemCode`, `itemValue`, `lastUpdate`, `lastUpdatedBy`)
 VALUES ('EXCHANGE_SEMESTER', 'Exchange Semester', now(), '1');
END IF;	

END $$
CALL V20240117170813__Insert_AdmissionInactiveReasonSeedData() $$
DROP PROCEDURE IF EXISTS V20240117170813__Insert_AdmissionInactiveReasonSeedData $$
DELIMITER ;