DELIMITER $$
DROP PROCEDURE IF EXISTS V20240221175156__Create_StdProgramWiseCondition $$
CREATE PROCEDURE V20240221175156__Create_StdProgramWiseCondition()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_program_wise_condition_detail')) THEN 
CREATE TABLE `student_program_wise_condition_detail`(
`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
`personId` BIGINT(20) NOT NULL,
`appProgramAdmDetailsId` bigint(20) NULL DEFAULT NULL,
`conditionSatisfactionDate` DATE DEFAULT NULL,
`conditionCheck` BIT(1) NULL DEFAULT NULL,
`admissionConditionId` BIGINT(20) NULL DEFAULT NULL,
`documentTypeId` BIGINT(20) NULL DEFAULT NULL,
`additionalCondition` TEXT DEFAULT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `student_program_wise_condition_detail_personId_FK` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `student_program_wise_condition_detail_admissionConditionId_FK` FOREIGN KEY (`admissionConditionId`) REFERENCES `admission_condition`(`id`),
CONSTRAINT `student_program_wise_condition_detail_appProgramAdmDetailsId_FK` FOREIGN KEY (`appProgramAdmDetailsId`) REFERENCES `app_program_adm_details`(`id`),
CONSTRAINT `student_program_wise_condition_detail_documentTypeId_FK` FOREIGN KEY (`documentTypeId`) REFERENCES `document_types`(`id`),
CONSTRAINT `student_program_wise_condition_detail_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ;
END IF; 

END $$
CALL V20240221175156__Create_StdProgramWiseCondition () $$ 
DROP PROCEDURE IF EXISTS V20240221175156__Create_StdProgramWiseCondition $$ 
DELIMITER ;