DELIMITER $$
DROP PROCEDURE IF EXISTS V20240227122030__Create_HostelAgeRestrictionType $$
CREATE PROCEDURE V20240227122030__Create_HostelAgeRestrictionType()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='hostel_age_restriction_type')) THEN 
CREATE TABLE `hostel_age_restriction_type` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(100) NOT NULL,
	`itemValue` VARCHAR(100) NOT NULL,
    `minAge` BIGINT(20) NOT NULL,
    `maxAge` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	UNIQUE KEY itemCode_UNIQUE (itemCode),
	CONSTRAINT `hostel_age_restriction_type_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'hostel_age_restriction_type')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'hostel_age_restriction_type','HOSTEL_AGE_RESTRICTION_TYPE','Fees & Payments','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;


IF  EXISTS ((SELECT * FROM standard_master WHERE tableName = 'hostel_age_restriction_type')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'hostel_age_restriction_type');
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='ITEM_CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='ITEM_VALUE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;


IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE  dbFieldName='minAge' AND fieldLabel='MIN_AGE' AND standardMasterId=@standardMasterId)) THEN
INSERT INTO standard_master_items( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES ('minAge', 'MIN_AGE', @standardMasterId, 'Number', '3', 0, 0, 0, false, '1', SYSDATE());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE  dbFieldName='maxAge' AND fieldLabel='MAX_AGE' AND standardMasterId=@standardMasterId)) THEN
INSERT INTO standard_master_items( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES ('maxAge', 'MAX_AGE', @standardMasterId, 'Number', '4', 0, 0, 0, false, '1', SYSDATE());
END IF;
END IF; 

END $$
CALL V20240227122030__Create_HostelAgeRestrictionType () $$ 
DROP PROCEDURE IF EXISTS V20240227122030__Create_HostelAgeRestrictionType $$ 
DELIMITER ;