DELIMITER $$
DROP PROCEDURE IF EXISTS V20240301184203__Create_CreateEnquiryAcademyLocation $$
CREATE PROCEDURE V20240301184203__Create_CreateEnquiryAcademyLocation()
BEGIN

IF NOT EXISTS ((SELECT * FROM `system_msg_event` WHERE `code`='CREATE_ENQUIRY_ACADEMY_LOCATION')) THEN 
SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='CREATE_ENQUIRY_VELOCITY');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'CREATE_ENQUIRY_ACADEMY_LOCATION', 'Create Enquiry Academy Location', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Create Enquiry Academy Location');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- DL data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'CREATE_ENQUIRY_ACADEMY_LOCATION_DL', 'SQL');

-- Recipient Infor data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'CREATE_ENQUIRY_ACADEMY_LOCATION_RECIPIENTS', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_ACADEMY_LOCATION_RECIPIENTS');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'CREATE_ENQUIRY_ACADEMY_LOCATION_RECIPIENTS');


-- The under sql code gives for the user distribution list ,this information can be fetched
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_ACADEMY_LOCATION_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='CREATE_ENQUIRY_ACADEMY_LOCATION_RECIPIENTS');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the Parent distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_ACADEMY_LOCATION_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id AS USER_ID FROM enquiry T1 where T1.id = (namedParams) 
 <MSG@ACAD_LOC_CRITERIA> AND T1.academyLocationId IN (msg_scope_acad_loc_Ids)</MSG>",NULL);

-- Setting data in cb_dtprovider for the PARENT_LOGIN_CREATION_TDP ADDED
-- SET @cbdtproviderId=(SELECT MAX(id) FROM `cb_dtprovider`);
-- SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='CREATE_ENQUIRY_TDP');
-- insert  into `cb_dtprovider`(`id`,`dataProviderId`,`searchConfigCode`,`searchResultViewCode`) values (@cbdtproviderId+1, @dtproviderId,'MSG_CREATE_ENQUIRY_TEMPLATE_DATA','MSG_CREATE_ENQUIRY_TEMPLATE_DATA');

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_ACADEMY_LOCATION_RECIPIENTS');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS PARENT_FIRST_NAME,
    T1.lastName AS PARENT_LAST_NAME,
    T2.studentFirstName AS FIRST_NAME,
    T2.studentLastName AS LAST_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    T1.primaryeEmailId AS EMAIL_ID,
    T1.phoneNo AS MOBILE_NO,
    T1.phoneCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
	T4.academyid AS ACADEMY_ID,
	T4.locationid AS LOCATION_ID,
    (Case 
    when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
        (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL    
FROM
    enquiry T1
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    admission_enq_details T3 ON T3.enqStudentDetailsId = T2.id
        LEFT JOIN
    academy_location T4 ON T4.id = T3.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId
        LEFT JOIN
    organizations org on org.id = 1
WHERE
    T1.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "ID",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },{
            "id": 2,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 1
        },{
            "id": 3,
            "value": "firstName",
            "resultKey": "PARENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "PARENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "studentFirstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "studentLastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 6
        },       
        {
            "id": 8,
            "value": "primaryeEmailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "locationId",
            "resultKey": "LOCATION_ID",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 16
        }
    ]
}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='CREATE_ENQUIRY_ACADEMY_LOCATION');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='CREATE_ENQUIRY_VELOCITY');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='CREATE_ENQUIRY_ACADEMY_LOCATION_RECIPIENTS');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Create Enquiry Academy Location Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Create Enquiry Academy Location Template',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Welcome - We can’t wait to meet you!','<html>
<head>
	<title></title>
</head>
<body>
<p>Lead ID&nbsp;<strong>$recipientData[&quot;ENQUIRY_CODE&quot;]</strong></p>

<p>Dear&nbsp;<strong>$recipientData[&quot;PARENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;PARENT_LASTNAME&quot;]</strong></p>

<p>Thank you for your interest in <strong>$recipientData[&quot;STUDENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;STUDENT_LASTNAME&quot;]</strong>&nbsp;joining our ever-growing <strong>$recipientData[&quot;ACADEMY_NAME&quot;]</strong>&nbsp;community. We look forward to a long and prosperous relationship with both you and your child. In fact, we have a dedicated team of staff who are ready and waiting to answer any questions you may have.</p>

<p><strong>What&rsquo;s the next step?</strong></p>

<p>If you require more information on our school or require any further assistance, please click here<br />
<strong>$recipientData[&quot;ACADEMY_EMAIL&quot;]</strong>&nbsp;and the school will contact you telephonically to discuss.</p>

<p><br />
If you are interested in applying for admission to our school, please click here <strong>$recipientData[&quot;WEBSITE_URL&quot;]</strong>&nbsp;to get the process started. Your application will be assessed and, depending on the grade (form or standard) you are enquiring for, an assessment/interview may be scheduled. If the assessment/interview has been successful, you will receive a &ldquo;Conditional Admission&rdquo; letter and on acceptance of the offer you will be able to complete the admission process by paying the relevant enrolment fee or submitting other required information as applicable.</p>

<p>We can&rsquo;t wait to hear back from you!</p>

<p>Kind regards,<br />
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></p>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["PARENT_FIRSTNAME"] $recipientData["PARENT_LASTNAME"],
Thank you for your interest in our school. We will be touch shortly. 
$recipientData["ACADEMY_NAME_LOCATION"]');
INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'4',NULL,'');

END IF; 

END $$
CALL V20240301184203__Create_CreateEnquiryAcademyLocation () $$ 
DROP PROCEDURE IF EXISTS V20240301184203__Create_CreateEnquiryAcademyLocation $$ 
DELIMITER ;