DELIMITER $$
DROP PROCEDURE IF EXISTS V20240416104922__Update_DocumentSubmissionReminderEvnt $$
CREATE PROCEDURE V20240416104922__Update_DocumentSubmissionReminderEvnt()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @dtproviderIdDl=(SELECT id FROM dtprovider WHERE `dataProviderName`='DOCUMENT_SUBMISSION_REMINDER_DL');
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DOCUMENT_SUBMISSION_REMINDER_RCPNT');
IF EXISTS (((SELECT * FROM dtprovider WHERE `dataProviderName`='DOCUMENT_SUBMISSION_REMINDER_RCPNT'))) THEN 
UPDATE sql_dtprovider
SET sqlQuery="SELECT 
	sd.studentId AS ID,
    T33.countryName AS Student_Address_countryName,
    T34.countryRegionName AS Student_Address_countryRegionName,
    T32.cityName AS Student_Address_cityName,
    T31.postalCode AS Student_Address_postalCode,
    T31.phoneNo AS Student_Address_phoneNo,
    T31.cellNo AS Student_Address_cellNo,
    T31.primaryeEmailId AS Student_Address_primaryeEmailId,
    T21.orgName AS ORGANIZATION_NAME,
    T25.countryName AS Organization_countryName,
    T26.countryRegionName AS Organization_countryRegionName,
    T24.cityName AS Organization_cityName,
    T23.postalCode AS Organization_postalCode,
    T23.phoneNo AS Organization_phoneNo,
    T23.cellNo AS Organization_cellNo,
    T23.primaryeEmailId AS Organization_primaryeEmailId,
    T17.displayName AS Academic_location,
    T3.code AS STUDENT_ID,
    T28.printName AS PERIOD_NAME,
    T1.mobileNumber AS MOBILE_NO,
    T1.emailId AS EMAIL_ID,
    T1.alternateEmailId AS SECONDARY_EMAIL_ID,
    T1.printName AS STUDENT_NAME,
    T1.firstName AS FIRST_NAME,
    T1.middleName AS MIDDLE_NAME,
    T1.lastName AS LAST_NAME,
    T5.programNameToBePrint AS Programme_Name,
    T4.code AS ADMISSION_ID,
	T29.printName AS BATCH_NAME,
        GROUP_CONCAT(DISTINCT T35.itemValue ORDER BY T35.itemCode SEPARATOR ', ') AS DOCUMENT_NAME,
    (CASE
        WHEN
            T17.logoUrl IS NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T17.logoUrl IS NULL
                AND T21.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(T21.orgUrl, '/', T17.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T17.headerUrl IS NOT NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl, '/', T17.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T17.footerUrl IS NOT NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl, '/', T17.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info
        WHERE
            fire_base_persons_info.userId = T3.id) AS DEVICE_ID
FROM
   student_documents sd 
   LEFT JOIN  
       users T3 ON T3.id = sd.studentId
        LEFT JOIN
	   students T2 ON T2.userId = T3.id
        LEFT JOIN
       persons T1 on T1.id = T2.personId
        LEFT JOIN
    admission T4 ON T4.studentId = T3.id
        LEFT JOIN
    programs T5 ON T5.id = T4.programId
        LEFT JOIN
    academy_location T17 ON T17.id = T4.academyLocationId
        LEFT JOIN
    academies T18 ON T18.id = T17.academyId
        LEFT JOIN
    locations T19 ON T19.id = T17.locationId
         LEFT JOIN
    organizations T21 ON T21.id = T18.organizationId
        LEFT JOIN
    organization_addresses T22 ON T22.organizationId = T21.id
        LEFT JOIN
    address T23 ON T23.id = T22.addressId
        LEFT JOIN
    city T24 ON T24.id = T23.cityId
        LEFT JOIN
    country T25 ON T25.id = T24.countryId
        LEFT JOIN
    country_region T26 ON T26.id = T24.countryRegionId
        LEFT JOIN
    program_batch_students T27 ON T27.admissionId = T4.id
        AND T27.isCurrentPeriod = TRUE
        AND T27.isCurrentSection = TRUE
        AND T27.isPeriodCompleted = FALSE
        AND T27.exitDate IS NULL
        LEFT JOIN
    prog_batch_period_config T28 ON T28.id = T27.progBatchPeriodConfigId
    LEFT JOIN
    batches T29 ON T29.id = T28.programBatchId
    LEFT JOIN
     person_addresses T30 ON T30.personId = T1.id and T30.addressTypeId=5
        LEFT JOIN
    address T31 ON T31.id = T30.addressId 
        LEFT JOIN
    city T32 ON T32.id = T31.cityId
        LEFT JOIN
    country T33 ON T33.id = T32.countryId
        LEFT JOIN
    country_region T34 ON T34.id = T32.countryRegionId
    LEFT JOIN
    document_types T35 ON T35.id = sd.documentTypeId
   
       WHERE
    sd.studentId in (namedParams) AND sd.status='PENDING_OPTIONAL' AND T23.addressTypeId = (SELECT 
            id
        FROM
            address_type oat
        WHERE
            oat.code = 'REG'
                AND oat.addressCategory = 'ORG') GROUP BY sd.studentId"
where dataProviderId = @dtproviderId;

UPDATE sql_dtprovider
SET sqlQuery="SELECT 
  sd.studentId AS USER_ID
FROM
    admission a  LEFT JOIN   
    student_documents sd on sd.studentId=a.studentId 
WHERE
    (a.admissionDate  >= (DATE_FORMAT(DATE(NOW())  - interval 45 day , '%Y-%m-%d')) and sd.status='PENDING_OPTIONAL' and sd.documentId IS NULL) group by sd.studentId"
where dataProviderId = @dtproviderIdDl;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240416104922__Update_DocumentSubmissionReminderEvnt () $$
DROP PROCEDURE IF EXISTS V20240416104922__Update_DocumentSubmissionReminderEvnt $$
DELIMITER ;